/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.bitbucket.codeinsights.report.InsightReportData;
import com.atlassian.bitbucket.codeinsights.report.InsightResult;
import com.atlassian.bitbucket.internal.codeinsights.rest.RestInsightReportData;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.util.MoreCollectors;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RestSetInsightReportRequest
extends RestMapEntity {
    public RestSetInsightReportRequest() {
    }

    RestSetInsightReportRequest(Map<String, ?> values) {
        super(values);
    }

    public RestSetInsightReportRequest(List<InsightReportData> data, Date createdDate, String details, URI link, URI logoUrl, InsightResult result, String title, String reporter) {
        this.putIfNotNull("data", data == null ? null : data.stream().map(RestInsightReportData::new).collect(MoreCollectors.toImmutableList()));
        this.putIfNotNull("details", details);
        this.putIfNotNull("title", title);
        this.putIfNotNull("reporter", reporter);
        if (createdDate != null) {
            this.putIfNotNull("createdDate", createdDate.getTime());
        }
        if (link != null) {
            this.putIfNotNull("link", link.toASCIIString());
        }
        if (logoUrl != null) {
            this.putIfNotNull("logoUrl", logoUrl.toASCIIString());
        }
        if (result != null) {
            this.putIfNotNull("result", result.toString());
        }
    }

    @NotNull(message="{bitbucket.rest.codeinsights.error.data.format}")
    @Size(max=6, message="{bitbucket.rest.codeinsights.error.data.size}")
    @Valid
    public @NotNull(message="{bitbucket.rest.codeinsights.error.data.format}") @Size(max=6, message="{bitbucket.rest.codeinsights.error.data.size}") @Valid List<RestInsightReportData> getData() {
        Object changes = this.get("data");
        if (changes == null) {
            return Collections.emptyList();
        }
        if (changes instanceof List) {
            List changeList = (List)changes;
            return (List)changeList.stream().map(RestInsightReportData::valueOf).filter(Objects::nonNull).collect(MoreCollectors.toImmutableList());
        }
        return null;
    }

    @Nullable
    public String getCoverageProviderKey() {
        return this.getStringProperty("coverageProviderKey");
    }

    @Schema(example="1630041546433")
    public long getCreatedDate() {
        return this.getLongProperty("createdDate");
    }

    @Schema(example="This is the details of the report, it can be a longer string describing the report.")
    @Nullable
    public String getDetails() {
        return this.getStringProperty("details");
    }

    @Schema(example="http://insight.example.com")
    @Nullable
    public String getLink() {
        return this.getStringProperty("link");
    }

    @Schema(example="http://insight.example.com/logo")
    @Nullable
    public String getLogoUrl() {
        return this.getStringProperty("logoUrl");
    }

    @Schema(example="Reporter/tool that produced this report")
    @Nullable
    @Size(max=450, message="{bitbucket.rest.codeinsights.error.reporter.length}")
    public @Size(max=450, message="{bitbucket.rest.codeinsights.error.reporter.length}") String getReporter() {
        return this.getStringProperty("reporter");
    }

    @Schema(example="PASS")
    @Nullable
    @Pattern(regexp="FAIL|PASS", message="{bitbucket.rest.codeinsights.error.result.pattern}")
    public @Pattern(regexp="FAIL|PASS", message="{bitbucket.rest.codeinsights.error.result.pattern}") String getResult() {
        return this.getStringProperty("result");
    }

    @Schema(example="report.title")
    @NotBlank(message="{bitbucket.rest.codeinsights.error.title.required}")
    @Size(max=450, message="{bitbucket.rest.codeinsights.error.title.length}")
    public @NotBlank(message="{bitbucket.rest.codeinsights.error.title.required}") @Size(max=450, message="{bitbucket.rest.codeinsights.error.title.length}") String getTitle() {
        return this.getStringProperty("title");
    }
}

