/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.codeinsights.rest;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RestSingleAddInsightAnnotationRequest
extends RestMapEntity {
    public static final String EXTERNAL_ID = "externalId";
    public static final String LINE = "line";
    public static final String LINK = "link";
    public static final String MESSAGE = "message";
    public static final String PATH = "path";
    public static final String SEVERITY = "severity";
    public static final String TYPE = "type";

    public RestSingleAddInsightAnnotationRequest() {
    }

    RestSingleAddInsightAnnotationRequest(Map<String, ?> values) {
        super(values);
    }

    @Schema(example="message-1")
    @Nullable
    @Size(max=450, message="{bitbucket.codeinsights.error.annotation.ext.id.too.long}")
    public @Size(max=450, message="{bitbucket.codeinsights.error.annotation.ext.id.too.long}") String getExternalId() {
        return this.getStringProperty(EXTERNAL_ID);
    }

    @Schema(implementation=Integer.class, example="4")
    @Min(value=0L, message="{bitbucket.rest.codeinsights.annotation.error.line.min}")
    public @Min(value=0L, message="{bitbucket.rest.codeinsights.annotation.error.line.min}") int getLine() {
        return this.getOptionalIntProperty(LINE).orElse(0);
    }

    @Schema(example="https://link.to.tool/that/produced/annotation/message-1")
    @Nullable
    public String getLink() {
        return this.getStringProperty(LINK);
    }

    @Schema(example="This is a bug here because reasons")
    @NotNull(message="{bitbucket.rest.codeinsights.annotation.error.message.required}")
    @Size(max=2000, message="{bitbucket.rest.codeinsights.annotation.error.message.length}")
    public @NotNull(message="{bitbucket.rest.codeinsights.annotation.error.message.required}") @Size(max=2000, message="{bitbucket.rest.codeinsights.annotation.error.message.length}") String getMessage() {
        return this.getStringProperty(MESSAGE);
    }

    @Schema(example="path/to/file/in/repo")
    @Size(max=50000, message="{bitbucket.rest.codeinsights.annotation.error.path.length}")
    public @Size(max=50000, message="{bitbucket.rest.codeinsights.annotation.error.path.length}") String getPath() {
        return StringUtils.stripToEmpty((String)this.getStringProperty(PATH));
    }

    @Schema(example="MEDIUM")
    @NotNull(message="{bitbucket.rest.codeinsights.annotation.error.severity.required}")
    @Pattern(regexp="LOW|MEDIUM|HIGH", message="{bitbucket.rest.codeinsights.annotation.error.severity.pattern}")
    public @NotNull(message="{bitbucket.rest.codeinsights.annotation.error.severity.required}") @Pattern(regexp="LOW|MEDIUM|HIGH", message="{bitbucket.rest.codeinsights.annotation.error.severity.pattern}") String getSeverity() {
        return this.getStringProperty(SEVERITY);
    }

    @Schema(example="CODE_SMELL")
    @Nullable
    @Pattern(regexp="VULNERABILITY|CODE_SMELL|BUG", message="{bitbucket.rest.codeinsights.annotation.error.type.pattern}")
    public @Pattern(regexp="VULNERABILITY|CODE_SMELL|BUG", message="{bitbucket.rest.codeinsights.annotation.error.type.pattern}") String getType() {
        return this.getStringProperty(TYPE);
    }

    @Nullable
    static RestSingleAddInsightAnnotationRequest valueOf(Object value) {
        if (value instanceof RestSingleAddInsightAnnotationRequest) {
            return (RestSingleAddInsightAnnotationRequest)((Object)value);
        }
        if (value instanceof Map) {
            return new RestSingleAddInsightAnnotationRequest((Map)value);
        }
        return null;
    }
}

