/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.lookandfeel;

import com.atlassian.bitbucket.internal.lookandfeel.ThemeUtils;
import java.awt.Color;

public enum AtlaskitToken {
    DSSurface("--ds-surface", "#1d2125", "#ffffff"),
    DSLinkPressed("--ds-link-pressed", "#85b8ff", "#0055cc"),
    DSTextLinkPressed("--ds-text-link-pressed", "#85b8ff", "#0055cc"),
    DSTextLinkResting("--ds-text-link-resting", "#579dff", "#0c66e4"),
    DSTextBrand("--ds-text-brand", "#579dff", "#0c66e4"),
    DSIconBrand("--ds-icon-brand", "#579dff", "#0c66e4"),
    DSBorderBrand("--ds-border-brand", "#579dff", "#0c66e4"),
    DSChartBrand("--ds-chart-brand", "#388bff", "#1d7afc"),
    DSChartBrandHovered("--ds-chart-brand-hovered", "#579dff", "#0c66e4"),
    DSIconBorderBrand("--ds-iconBorder-brand", "#388bff", "#1d7afc"),
    DSIconborderBrand("--ds-iconborder-brand", "#388bff", "#1d7afc"),
    DSIconSelected("--ds-icon-selected", "#579dff", "#0c66e4"),
    DSBorderSelected("--ds-border-selected", "#579dff", "#0c66e4"),
    DSBackgroundBrand("--ds-background-brand", "#082145", "#e9f2ff"),
    DSBackgroundBrandHovered("--ds-background-brand-hovered", "#09326c", "#cce0ff"),
    DSBackgroundBrandPressed("--ds-background-brand-pressed", "#0055cc", "#85b8ff"),
    DSBackgroundBrandSubtlest("--ds-background-brand-subtlest", "#1c2b41", "#e9f2ff"),
    DSBackgroundBrandSubtlestHovered("--ds-background-brand-subtlest-hovered", "#09326c", "#cce0ff"),
    DSBackgroundBrandSubtlestPressed("--ds-background-brand-subtlest-pressed", "#0055cc", "#85b8ff"),
    DSBackgroundBrandBold("--ds-background-brand-bold", "#579dff", "#0c66e4"),
    DSBackgroundBrandBoldHovered("--ds-background-brand-bold-hovered", "#85b8ff", "#0055cc"),
    DSBackgroundBrandBoldPressed("--ds-background-brand-bold-pressed", "#cce0ff", "#09326c"),
    DSBackgroundBrandBoldest("--ds-background-brand-boldest", "#e9f2ff", "#1c2b41"),
    DSBackgroundBrandBoldestHovered("--ds-background-brand-boldest-hovered", "#cce0ff", "#09326c"),
    DSBackgroundBrandBoldestPressed("--ds-background-brand-boldest-pressed", "#85b8ff", "#0055cc"),
    DSBackgroundBoldbrandHover("--ds-background-boldbrand-hover", "#85b8ff", "#0055cc"),
    DSBackgroundBoldbrandPressed("--ds-background-boldbrand-pressed", "#cce0ff", "#09326c"),
    DSBackgroundBoldbrandResting("--ds-background-boldbrand-resting", "#579dff", "#0c66e4"),
    DSBackgroundSubtlebrandHover("--ds-background-subtlebrand-hover", "#09326c", "#cce0ff"),
    DSBackgroundSubtlebrandPressed("--ds-background-subtlebrand-pressed", "#0055cc", "#85b8ff"),
    DSBackgroundSubtlebrandResting("--ds-background-subtlebrand-resting", "#082145", "#e9f2ff"),
    DSBackgroundSelectedResting("--ds-background-selected-resting", "#a1bdd914", "#e9f2ff"),
    DSBackgroundSelectedHover("--ds-background-selected-hover", "#a6c5e229", "#cce0ff"),
    DSBackgroundSelected("--ds-background-selected", "#1c2b41", "#e9f2ff"),
    DSBackgroundSelectedHovered("--ds-background-selected-hovered", "#09326c", "#cce0ff"),
    DSBackgroundSelectedPressed("--ds-background-selected-pressed", "#0055cc", "#85b8ff"),
    DSBackgroundSelectedBold("--ds-background-selected-bold", "#579dff", "#0c66e4"),
    DSBackgroundSelectedBoldHovered("--ds-background-selected-bold-hovered", "#85b8ff", "#0055cc"),
    DSBackgroundSelectedBoldPressed("--ds-background-selected-bold-pressed", "#cce0ff", "#09326c"),
    DSTextSubtlest("--ds-text-subtlest", "#8c9bab", "#626f86"),
    DSTextSubtle("--ds-text-subtle", "#9fadbc", "#44546f"),
    DSIcon("--ds-icon", "#9fadbc", "#44546f"),
    DSBackgroundNeutralHovered("--ds-background-neutral-hovered", "#a6c5e229", "#091e4224"),
    DSBackgroundNeutralSubtlePressed("--ds-background-neutral-subtle-pressed", "#a6c5e229", "#091e4224"),
    DSBorder("--ds-border", "#a6c5e229", "#091e4224"),
    DSLink("--ds-link", "#579dff", "#0c66e4"),
    DSText("--ds-text", "#b6c2cf", "#172b4d"),
    DSTextInverse("--ds-text-inverse", "#1d2125", "#ffffff"),
    DSTextSelected("--ds-text-selected", "#579dff", "#0c66e4");

    public static final AtlaskitToken[] HEADER_TOKENS;
    public static final AtlaskitToken[] BRAND_TOKENS;
    private Color darkColor = null;
    private Color lightColor = null;
    private String name = null;

    private AtlaskitToken(String name, String darkColorHEXValue, String lightColorHexValue) {
        this.name = name;
        this.darkColor = ThemeUtils.hexToColor(darkColorHEXValue);
        this.lightColor = ThemeUtils.hexToColor(lightColorHexValue);
    }

    public Color getColor(boolean isDark) {
        return isDark ? this.darkColor : this.lightColor;
    }

    public Color getDarkColor() {
        return this.darkColor;
    }

    public Color getLightColor() {
        return this.lightColor;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBold() {
        return this.name.contains("bold");
    }

    public boolean isBackground() {
        return this.name.contains("background");
    }

    public String toString() {
        return this.getName() + "=> Dark: " + String.valueOf(this.getDarkColor()) + ", Light:" + String.valueOf(this.getLightColor());
    }

    static {
        HEADER_TOKENS = new AtlaskitToken[]{DSBackgroundNeutralHovered, DSBackgroundNeutralSubtlePressed, DSBorder, DSText, DSTextSubtlest, DSTextSubtle, DSIcon};
        BRAND_TOKENS = new AtlaskitToken[]{DSLink, DSTextSelected, DSLinkPressed, DSTextLinkPressed, DSTextLinkResting, DSTextBrand, DSIconBrand, DSBorderBrand, DSChartBrand, DSChartBrandHovered, DSIconBorderBrand, DSIconborderBrand, DSIconSelected, DSBorderSelected, DSBackgroundBrand, DSBackgroundBrandHovered, DSBackgroundBrandPressed, DSBackgroundBrandSubtlest, DSBackgroundBrandSubtlestHovered, DSBackgroundBrandSubtlestPressed, DSBackgroundBrandBold, DSBackgroundBrandBoldHovered, DSBackgroundBrandBoldPressed, DSBackgroundBrandBoldest, DSBackgroundBrandBoldestHovered, DSBackgroundBrandBoldestPressed, DSBackgroundBoldbrandHover, DSBackgroundBoldbrandPressed, DSBackgroundBoldbrandResting, DSBackgroundSubtlebrandHover, DSBackgroundSubtlebrandPressed, DSBackgroundSubtlebrandResting, DSBackgroundSelectedResting, DSBackgroundSelectedHover, DSBackgroundSelected, DSBackgroundSelectedHovered, DSBackgroundSelectedPressed, DSBackgroundSelectedBold, DSBackgroundSelectedBoldHovered, DSBackgroundSelectedBoldPressed};
    }
}

