/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.lookandfeel;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.bitbucket.internal.lookandfeel.ImageUtils;
import com.atlassian.bitbucket.internal.lookandfeel.LookAndFeelSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;

@UnrestrictedAccess
public class FaviconInterceptor
implements Filter {
    private final PluginSettingsFactory pluginSettingsFactory;

    public FaviconInterceptor(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        LookAndFeelSettings settings = LookAndFeelSettings.getLookAndFeelSettings(this.pluginSettingsFactory);
        String faviconImage = settings.getFaviconImage();
        if (faviconImage != null) {
            response.setContentType("image/png");
            byte[] pngData = ImageUtils.extractImageData(faviconImage);
            ServletOutputStream out = response.getOutputStream();
            out.write(pngData);
            out.close();
            return;
        }
        filterChain.doFilter(request, response);
    }
}

