/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.lookandfeel;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class ImageUtils {
    private static final Pattern BASE64_DATA_URI = Pattern.compile("^data:[^;]+;base64,");
    private static final String BASE64_PNG_DATA_URI_HEADER = "data:image/png;base64,";

    public static String asDataURI(byte[] input) {
        return BASE64_PNG_DATA_URI_HEADER + Base64.getEncoder().encodeToString(input);
    }

    public static byte[] convertToPNG(BufferedImage img) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, "PNG", bos);
        return bos.toByteArray();
    }

    public static byte[] extractImageData(String dataURI) {
        Matcher matcher = BASE64_DATA_URI.matcher(dataURI);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Only base64 data URIs are supported");
        }
        int start = matcher.end();
        return Base64.getDecoder().decode(dataURI.substring(start));
    }

    public static BufferedImage rescale(BufferedImage img, int targetHeight) {
        int width = img.getWidth();
        int height = img.getHeight();
        width = (int)((float)width / ((float)height / (float)targetHeight));
        BufferedImage scaled = new BufferedImage(width, targetHeight, 2);
        Graphics g = scaled.getGraphics();
        g.drawImage(img, 0, 0, width, targetHeight, 0, 0, img.getWidth(), img.getHeight(), null);
        return scaled;
    }
}

