/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.lookandfeel;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.bitbucket.internal.lookandfeel.ImageUtils;
import com.atlassian.bitbucket.internal.lookandfeel.LookAndFeelSettings;
import com.atlassian.bitbucket.internal.lookandfeel.ThemeUtils;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.lookandfeel.ImageInfo;
import com.atlassian.plugin.webresource.WebResourceBatchingStateCounter;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;

@AdminOnly
public class LookAndFeelServlet
extends HttpServlet {
    public static final String CUSTOM_HEADER_COLOR_KEY = "customThemeHeaderColour";
    public static final String CUSTOM_PRIMARY_COLOR_KEY = "customThemePrimaryColour";
    public static final String FAVICON_IMAGE = "favicon-upload";
    public static final String FAVICON_IMAGE_KEY = "faviconImage";
    public static final String HEADER_COLOR = "header-colour";
    public static final String HEADER_COLOR_KEY = "headerColour";
    public static final String HEADER_IMAGE_KEY = "headerImage";
    public static final String LOGO_IMAGE = "logo-upload";
    public static final String MODULE_KEY = "com.atlassian.bitbucket.server.bitbucket-look-and-feel";
    public static final String PRIMARY_COLOR = "primary-colour";
    public static final String PRIMARY_COLOR_KEY = "primaryColour";
    public static final String RESET_THEME = "look-and-feel-reset-default";
    public static final String TEMPLATE = "bitbucket.feature.lookAndFeel.settings";
    private final NavBuilder navBuilder;
    private final PermissionValidationService permissionValidationService;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final WebResourceBatchingStateCounter stateCounter;
    private final XsrfTokenAccessor xsrfTokenAccessor;
    private final XsrfTokenValidator xsrfTokenValidator;

    public LookAndFeelServlet(SoyTemplateRenderer soyTemplateRenderer, PluginSettingsFactory pluginSettingsFactory, PermissionValidationService permissionValidationService, NavBuilder navBuilder, XsrfTokenAccessor xsrfTokenAccessor, XsrfTokenValidator xsrfTokenValidator, WebResourceBatchingStateCounter stateCounter) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.permissionValidationService = permissionValidationService;
        this.navBuilder = navBuilder;
        this.xsrfTokenAccessor = xsrfTokenAccessor;
        this.xsrfTokenValidator = xsrfTokenValidator;
        this.stateCounter = stateCounter;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        LookAndFeelSettings settings = LookAndFeelSettings.getLookAndFeelSettings(this.pluginSettingsFactory);
        this.render(req, resp, TEMPLATE, settings);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.xsrfTokenValidator.validateFormEncodedToken(req)) {
            req.getRequestDispatcher(this.navBuilder.xsrfNotification().buildRelNoContext()).forward((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        LookAndFeelSettings settings = LookAndFeelSettings.getLookAndFeelSettings(this.pluginSettingsFactory);
        String headerImageDataUri = req.getParameter(LOGO_IMAGE);
        String faviconImageDataUri = req.getParameter(FAVICON_IMAGE);
        if (req.getParameter(RESET_THEME) != null) {
            this.resetTheme(settings);
            this.stateCounter.incrementCounter();
        } else {
            if (StringUtils.isNotEmpty((CharSequence)headerImageDataUri)) {
                this.updateHeaderImage(settings, headerImageDataUri);
            } else {
                this.updateHeaderColors(settings, req);
            }
            if (StringUtils.isNotEmpty((CharSequence)faviconImageDataUri)) {
                this.updateFavicon(settings, faviconImageDataUri);
                this.stateCounter.incrementCounter();
            }
        }
        this.render(req, resp, TEMPLATE, settings);
    }

    private Map<String, Object> getInjectedData(HttpServletRequest req, HttpServletResponse resp) {
        HashMap<String, Object> injectedData = new HashMap<String, Object>();
        injectedData.put("xsrfTokenName", this.xsrfTokenValidator.getXsrfParameterName());
        injectedData.put("xsrfTokenValue", this.xsrfTokenAccessor.getXsrfToken(req, resp, true));
        return injectedData;
    }

    private void render(HttpServletRequest req, HttpServletResponse resp, String templateName, LookAndFeelSettings settings) throws IOException, ServletException {
        Map<String, String> theme = settings.getLookAndFeel();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (theme.containsKey(CUSTOM_PRIMARY_COLOR_KEY)) {
            builder.put((Object)PRIMARY_COLOR_KEY, (Object)theme.get(CUSTOM_PRIMARY_COLOR_KEY));
        } else {
            builder.put((Object)PRIMARY_COLOR_KEY, (Object)"#3572b0");
        }
        if (theme.containsKey(CUSTOM_HEADER_COLOR_KEY)) {
            builder.put((Object)HEADER_COLOR_KEY, (Object)theme.get(CUSTOM_HEADER_COLOR_KEY));
        } else {
            builder.put((Object)HEADER_COLOR_KEY, (Object)"#205081");
        }
        String headerImage = settings.getHeaderImage();
        String faviconImage = settings.getFaviconImage();
        if (headerImage != null) {
            builder.put((Object)HEADER_IMAGE_KEY, (Object)headerImage);
        }
        if (faviconImage != null) {
            builder.put((Object)FAVICON_IMAGE_KEY, (Object)faviconImage);
        }
        resp.setContentType("text/html;charset=UTF-8");
        try {
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), "com.atlassian.bitbucket.server.bitbucket-look-and-feel:look-and-feel-settings-serverside-resources", templateName, (Map)builder.build(), this.getInjectedData(req, resp));
        }
        catch (SoyException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new ServletException((Throwable)e);
        }
    }

    private void resetTheme(LookAndFeelSettings settings) {
        settings.clearLookAndFeel();
    }

    private void updateFavicon(LookAndFeelSettings settings, String dataURI) throws IOException {
        byte[] buf = ImageUtils.extractImageData(dataURI);
        BufferedImage img = ImageIO.read(new ByteArrayInputStream(buf));
        byte[] pngData = ImageUtils.convertToPNG(ImageUtils.rescale(img, 32));
        String newFaviconImage = ImageUtils.asDataURI(pngData);
        settings.setFaviconImage(newFaviconImage);
    }

    private void updateHeaderColors(LookAndFeelSettings settings, HttpServletRequest req) {
        String primaryColor = ThemeUtils.validateHexColor(req.getParameter(PRIMARY_COLOR));
        String headerColor = ThemeUtils.validateHexColor(req.getParameter(HEADER_COLOR));
        ImmutableMap.Builder theme = ImmutableMap.builder();
        if (!primaryColor.equals("#3572b0")) {
            theme.put((Object)CUSTOM_PRIMARY_COLOR_KEY, (Object)primaryColor);
        }
        if (!headerColor.equals("#205081")) {
            theme.put((Object)CUSTOM_HEADER_COLOR_KEY, (Object)headerColor);
        }
        settings.setLookAndFeel((Map<String, String>)theme.build());
    }

    private void updateHeaderImage(LookAndFeelSettings settings, String dataURI) throws IOException {
        byte[] buf = ImageUtils.extractImageData(dataURI);
        BufferedImage img = ImageIO.read(new ByteArrayInputStream(buf));
        ImageInfo logoInfo = new ImageInfo(img);
        String headerColor = logoInfo.isTransparentBackground() ? (logoInfo.getPredominantColor() != null && !logoInfo.isTooBrightForWhiteBackground() ? logoInfo.getPredominantColor().darkenByPercentage(20.0f).getHexString() : null) : logoInfo.getBackgroundColor().getHexString();
        String primaryColor = logoInfo.getPredominantColor() != null ? logoInfo.getPredominantColor().getHexString() : null;
        byte[] pngData = ImageUtils.convertToPNG(ImageUtils.rescale(img, 80));
        String newHeaderImage = ImageUtils.asDataURI(pngData);
        ImmutableMap.Builder theme = ImmutableMap.builder();
        if (primaryColor != null) {
            theme.put((Object)CUSTOM_PRIMARY_COLOR_KEY, (Object)primaryColor);
        }
        if (headerColor != null) {
            theme.put((Object)CUSTOM_HEADER_COLOR_KEY, (Object)headerColor);
        }
        settings.setLookAndFeel((Map<String, String>)theme.build());
        settings.setHeaderImage(newHeaderImage);
    }
}

