/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.lookandfeel;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class LookAndFeelSettings {
    public static final String DEFAULT_HEADER_COLOR = "#205081";
    public static final String DEFAULT_LINK_COLOR = "#3572b0";
    public static final int FAVICON_IMAGE_HEIGHT = 32;
    public static final int HEADER_IMAGE_HEIGHT = 80;
    static final String FAVICON_IMAGE_STORE_KEY = "look-and-feel:FAVICON_IMAGE";
    static final String HEADER_IMAGE_STORE_KEY = "look-and-feel:HEADER_IMAGE";
    static final String MODIFIED_STORE_KEY = "look-and-feel:MODIFIED_TIME";
    static final String THEME_STORE_KEY = "look-and-feel:COLOR_MAP";
    private final PluginSettings settings;

    public LookAndFeelSettings(PluginSettings settings) {
        this.settings = Objects.requireNonNull(settings, "settings");
    }

    public void clearLookAndFeel() {
        this.settings.remove(THEME_STORE_KEY);
        this.settings.remove(HEADER_IMAGE_STORE_KEY);
        this.settings.remove(FAVICON_IMAGE_STORE_KEY);
        this.settings.put(MODIFIED_STORE_KEY, (Object)Long.toString(new Date().getTime()));
    }

    public String getFaviconImage() {
        Object obj = this.settings.get(FAVICON_IMAGE_STORE_KEY);
        if (obj != null && obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public String getHeaderImage() {
        Object obj = this.settings.get(HEADER_IMAGE_STORE_KEY);
        if (obj != null && obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public long getLastModified() {
        Object obj = this.settings.get(MODIFIED_STORE_KEY);
        if (obj != null && obj instanceof String) {
            try {
                return Long.parseLong((String)obj);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return System.currentTimeMillis();
    }

    public Map<String, String> getLookAndFeel() {
        Object obj = this.settings.get(THEME_STORE_KEY);
        if (obj == null || !(obj instanceof Map)) {
            return ImmutableMap.of();
        }
        return (Map)obj;
    }

    public static LookAndFeelSettings getLookAndFeelSettings(PluginSettingsFactory settingsFactory) {
        PluginSettings settings = settingsFactory.createGlobalSettings();
        return new LookAndFeelSettings(settings);
    }

    public void setFaviconImage(String faviconImage) {
        this.settings.put(FAVICON_IMAGE_STORE_KEY, (Object)faviconImage);
        this.settings.put(MODIFIED_STORE_KEY, (Object)Long.toString(new Date().getTime()));
    }

    public void setHeaderImage(String headerImage) {
        this.settings.put(HEADER_IMAGE_STORE_KEY, (Object)headerImage);
        this.settings.put(MODIFIED_STORE_KEY, (Object)Long.toString(new Date().getTime()));
    }

    public void setLookAndFeel(Map<String, String> theme) {
        this.settings.put(THEME_STORE_KEY, theme);
        this.settings.put(MODIFIED_STORE_KEY, (Object)Long.toString(new Date().getTime()));
    }
}

