/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.lookandfeel;

import com.atlassian.bitbucket.internal.lookandfeel.LookAndFeelSettings;
import com.atlassian.bitbucket.internal.lookandfeel.ThemeUtils;
import com.atlassian.lookandfeel.spi.internal.LookAndFeelVariablesProvider;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.HashMap;
import java.util.Map;

public class LookAndFeelVariableProvider
implements LookAndFeelVariablesProvider {
    private final PluginSettingsFactory pluginSettingsFactory;

    public LookAndFeelVariableProvider(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public Map<String, String> getDarkModeVariables() {
        return this.getVariables(true);
    }

    public Map<String, String> getLightModeVariables() {
        return this.getVariables(false);
    }

    private Map<String, String> getVariables(boolean isDarkMode) {
        LookAndFeelSettings settings = LookAndFeelSettings.getLookAndFeelSettings(this.pluginSettingsFactory);
        Map<String, String> colourMap = settings.getLookAndFeel();
        HashMap<String, String> variables = new HashMap<String, String>();
        String headerImage = settings.getHeaderImage();
        boolean hasCustomHeaderImage = headerImage != null;
        boolean hasCustomPrimaryColor = colourMap.containsKey("customThemePrimaryColour");
        boolean hasCustomHeaderColor = colourMap.containsKey("customThemeHeaderColour");
        String primaryColor = colourMap.get("customThemePrimaryColour");
        if (hasCustomPrimaryColor) {
            variables.put("--bb-theme-primary-color", primaryColor);
            variables.putAll(ThemeUtils.getThemeCssVariables(primaryColor, isDarkMode));
        }
        if (hasCustomHeaderColor) {
            String headerColor = colourMap.get("customThemeHeaderColour");
            boolean isDarkHeaderColor = ThemeUtils.calculateRelativeLuminance(ThemeUtils.hexToColor(headerColor)) < 0.43;
            variables.put("--bb-theme-header-bg-color", headerColor);
            variables.put("--bb-theme-header-bg-color-is-dark", isDarkHeaderColor ? "true" : "false");
            variables.putAll(ThemeUtils.getHeaderThemeCssVariables(headerColor, isDarkHeaderColor, hasCustomPrimaryColor ? primaryColor : null));
        }
        if (hasCustomHeaderImage) {
            variables.put("--bb-theme-header-logo-image", String.format("url('%s')", headerImage));
        }
        return variables;
    }
}

