/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.lookandfeel;

import com.atlassian.bitbucket.internal.lookandfeel.AtlaskitToken;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class ThemeUtils {
    public static final double AA_MIN_CONTRAST_RATIO = 4.5;
    public static final double AAA_MIN_CONTRAST_RATIO = 7.0;
    private static final String CSS_VAR_PREFIX = "--bb-theme";
    private static final String CSS_VAR_HEADER_PREFIX = "--bb-theme-header";
    private static final String DEFAULT_COLOR = "#FFFFFF";

    public static Color adjustContrastRatio(Color color, Color backgroundColor, double minContrastRatio) {
        Color adjustedColor = color;
        boolean adjustmentStep = true;
        if (ThemeUtils.calculateContrastRatio(adjustedColor, backgroundColor) >= minContrastRatio) {
            return adjustedColor;
        }
        boolean shouldBrighten = ThemeUtils.calculateRelativeLuminance(adjustedColor) < ThemeUtils.calculateRelativeLuminance(backgroundColor);
        if (ThemeUtils.calculateContrastRatio(adjustedColor = ThemeUtils.adjustContrastRatio(color, backgroundColor, minContrastRatio, shouldBrighten), backgroundColor) >= minContrastRatio) {
            return adjustedColor;
        }
        adjustedColor = ThemeUtils.adjustContrastRatio(color, backgroundColor, minContrastRatio, !shouldBrighten);
        if (ThemeUtils.calculateContrastRatio(adjustedColor, backgroundColor) >= minContrastRatio) {
            return adjustedColor;
        }
        return color;
    }

    public static Color adjustContrastRatio(Color color, Color backgroundColor, double minContrastRatio, boolean shouldBrighten) {
        int[] rgb = new int[]{color.getRed(), color.getGreen(), color.getBlue()};
        Color adjustedColor = color;
        while (ThemeUtils.calculateContrastRatio(adjustedColor, backgroundColor) < minContrastRatio) {
            for (int component = 0; component < rgb.length; ++component) {
                rgb[component] = shouldBrighten ? Math.min(rgb[component] + 1, 255) : Math.max(rgb[component] - 1, 0);
            }
            adjustedColor = new Color(rgb[0], rgb[1], rgb[2]);
            if (!adjustedColor.equals(Color.white) && !adjustedColor.equals(Color.black)) continue;
            return adjustedColor;
        }
        return adjustedColor;
    }

    public static Color adjustLuminance(Color color, Color targetColor, Color baseColor) {
        float[] colorHsbVals = new float[3];
        float[] targetColorHsbVals = new float[3];
        float[] baseColorHsbVals = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), colorHsbVals);
        Color.RGBtoHSB(targetColor.getRed(), targetColor.getGreen(), targetColor.getBlue(), targetColorHsbVals);
        Color.RGBtoHSB(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), baseColorHsbVals);
        float lumaDiff = targetColorHsbVals[2] - baseColorHsbVals[2];
        colorHsbVals[2] = Math.max(0.0f, Math.min(1.0f, colorHsbVals[2] + lumaDiff));
        return Color.getHSBColor(colorHsbVals[0], colorHsbVals[1], colorHsbVals[2]);
    }

    public static double calculateContrastRatio(Color color, Color backgroundColor) {
        double colorLuminance = ThemeUtils.calculateRelativeLuminance(color);
        double backgroundLuminance = ThemeUtils.calculateRelativeLuminance(backgroundColor);
        double maxLuminance = Math.max(colorLuminance, backgroundLuminance);
        double minLuminance = Math.min(colorLuminance, backgroundLuminance);
        return (maxLuminance + 0.05) / (minLuminance + 0.05);
    }

    public static double calculateLinearComponent(double component) {
        if (component <= 0.03928) {
            return component / 12.92;
        }
        return Math.pow((component + 0.055) / 1.055, 2.4);
    }

    public static double calculateRelativeLuminance(Color color) {
        double red = ThemeUtils.calculateLinearComponent((double)color.getRed() / 255.0);
        double green = ThemeUtils.calculateLinearComponent((double)color.getGreen() / 255.0);
        double blue = ThemeUtils.calculateLinearComponent((double)color.getBlue() / 255.0);
        return 0.2126 * red + 0.7152 * green + 0.0722 * blue;
    }

    public static String colorToHex(Color color) {
        Object hexColor = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
        if (color.getAlpha() != 255) {
            hexColor = (String)hexColor + String.format("%02x", color.getAlpha());
        }
        return hexColor;
    }

    public static Map<String, String> getHeaderThemeCssVariables(String headerColor, boolean isDarkHeaderColor, String primaryColor) {
        HashMap<String, String> allVariables = new HashMap<String, String>();
        HashMap<String, String> result = new HashMap<String, String>();
        Color backgroundColor = ThemeUtils.hexToColor(headerColor);
        Color dsTextSelectedColor = AtlaskitToken.DSTextSelected.getColor(isDarkHeaderColor);
        for (AtlaskitToken token : AtlaskitToken.HEADER_TOKENS) {
            Color tokenColor = token.getColor(isDarkHeaderColor);
            if (!token.isBackground()) {
                tokenColor = ThemeUtils.adjustContrastRatio(tokenColor, backgroundColor, 7.0);
            }
            allVariables.put(token.getName(), ThemeUtils.colorToHex(tokenColor));
        }
        if (primaryColor != null) {
            Color adjustedPrimaryColor = ThemeUtils.adjustContrastRatio(ThemeUtils.hexToColor(primaryColor), backgroundColor, 7.0);
            String string = ThemeUtils.colorToHex(adjustedPrimaryColor);
            allVariables.put(AtlaskitToken.DSTextSelected.getName(), string);
            allVariables.put(AtlaskitToken.DSBorderBrand.getName(), string);
        } else {
            allVariables.put(AtlaskitToken.DSTextSelected.getName(), ThemeUtils.colorToHex(dsTextSelectedColor));
            allVariables.put(AtlaskitToken.DSBorderBrand.getName(), ThemeUtils.colorToHex(dsTextSelectedColor));
        }
        for (Map.Entry entry : allVariables.entrySet()) {
            result.put(CSS_VAR_HEADER_PREFIX + ((String)entry.getKey()).substring(1), (String)entry.getValue());
        }
        return result;
    }

    public static Map<String, String> getThemeCssVariables(String primaryHEXColor, boolean isDarkMode) {
        HashMap<String, String> result = new HashMap<String, String>();
        Color primaryColor = ThemeUtils.hexToColor(primaryHEXColor);
        Color backgroundColor = AtlaskitToken.DSSurface.getColor(isDarkMode);
        Color textColor = AtlaskitToken.DSText.getColor(isDarkMode);
        Color textColorInverse = AtlaskitToken.DSTextInverse.getColor(isDarkMode);
        Color brandTextColor = AtlaskitToken.DSTextBrand.getColor(isDarkMode);
        Color brandBackgroundColor = AtlaskitToken.DSBackgroundBrandBold.getColor(isDarkMode);
        Color contrastedPrimaryColor = ThemeUtils.adjustContrastRatio(primaryColor, backgroundColor, 7.0);
        for (AtlaskitToken token : AtlaskitToken.BRAND_TOKENS) {
            Color color = token.isBackground() ? primaryColor : contrastedPrimaryColor;
            Color tokenColor = token.getColor(isDarkMode);
            Color contrastColor = token.isBackground() ? (token.isBold() ? textColorInverse : textColor) : backgroundColor;
            Color baseColor = token.isBackground() ? brandBackgroundColor : brandTextColor;
            Color adjustedColor = ThemeUtils.adjustLuminance(color, tokenColor, baseColor);
            adjustedColor = ThemeUtils.adjustContrastRatio(adjustedColor, contrastColor, 4.5);
            result.put(CSS_VAR_PREFIX + token.getName().substring(1), ThemeUtils.colorToHex(adjustedColor));
        }
        return result;
    }

    public static Color hexToColor(String hexColor) {
        if (hexColor.length() > 7) {
            int red = Integer.parseInt(hexColor.substring(1, 3), 16);
            int green = Integer.parseInt(hexColor.substring(3, 5), 16);
            int blue = Integer.parseInt(hexColor.substring(5, 7), 16);
            int alpha = Integer.parseInt(hexColor.substring(7, 9), 16);
            return new Color(red, green, blue, alpha);
        }
        return Color.decode(hexColor);
    }

    public static Color matchLuminance(Color color, Color targetColor) {
        float[] colorHsbVals = new float[3];
        float[] targetColorHsbVals = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), colorHsbVals);
        Color.RGBtoHSB(targetColor.getRed(), targetColor.getGreen(), targetColor.getBlue(), targetColorHsbVals);
        return Color.getHSBColor(colorHsbVals[0], colorHsbVals[1], targetColorHsbVals[2]);
    }

    public static String validateHexColor(String input) {
        try {
            int num;
            int origLen = input.length();
            if (input.charAt(0) == '#') {
                num = Integer.parseInt(input.substring(1), 16);
                --origLen;
            } else {
                num = Integer.parseInt(input, 16);
            }
            StringBuilder out = new StringBuilder(Integer.toHexString(num));
            while (out.length() < origLen) {
                out.insert(0, "0");
            }
            if (out.length() == 6 || out.length() == 3) {
                return "#" + String.valueOf(out);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return DEFAULT_COLOR;
    }
}

