/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.http;

import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.CrowdClient;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCrowdHttpAuthenticator
implements CrowdHttpAuthenticator {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CrowdHttpAuthenticator.class);
    protected final CrowdClient client;
    protected final ClientProperties clientProperties;
    protected final CrowdHttpTokenHelper tokenHelper;

    public AbstractCrowdHttpAuthenticator(CrowdClient client, ClientProperties clientProperties, CrowdHttpTokenHelper tokenHelper) {
        this.client = client;
        this.clientProperties = clientProperties;
        this.tokenHelper = tokenHelper;
    }

    @Override
    public User getUser(HttpServletRequest request) throws InvalidTokenException, ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException {
        String ssoToken = this.tokenHelper.getCrowdToken(request, this.getCookieTokenKey());
        if (ssoToken != null) {
            return this.client.findUserFromSSOToken(ssoToken);
        }
        LOGGER.debug("Could not find user from token.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User authenticate(HttpServletRequest request, HttpServletResponse response, String username, String password) throws InvalidTokenException, ApplicationAccessDeniedException, ExpiredCredentialException, InactiveAccountException, ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException {
        UserAuthenticationContext userAuthenticationContext = this.tokenHelper.getUserAuthenticationContext(request, username, password, this.clientProperties);
        CookieConfiguration cookieConfig = this.client.getCookieConfiguration();
        String ssoToken = null;
        try {
            ssoToken = this.client.authenticateSSOUser(userAuthenticationContext);
            this.tokenHelper.setCrowdToken(request, response, ssoToken, this.clientProperties, cookieConfig);
        }
        finally {
            if (ssoToken == null) {
                this.tokenHelper.removeCrowdToken(request, response, this.clientProperties, cookieConfig);
            }
        }
        return this.client.findUserFromSSOToken(ssoToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User authenticateWithoutValidatingPassword(HttpServletRequest request, HttpServletResponse response, String username) throws InvalidTokenException, ApplicationAccessDeniedException, InactiveAccountException, ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException {
        UserAuthenticationContext userAuthenticationContext = this.tokenHelper.getUserAuthenticationContext(request, username, null, this.clientProperties);
        CookieConfiguration cookieConfig = this.client.getCookieConfiguration();
        String ssoToken = null;
        try {
            ssoToken = this.client.authenticateSSOUserWithoutValidatingPassword(userAuthenticationContext);
            this.tokenHelper.setCrowdToken(request, response, ssoToken, this.clientProperties, cookieConfig);
        }
        finally {
            if (ssoToken == null) {
                this.tokenHelper.removeCrowdToken(request, response, this.clientProperties, cookieConfig);
            }
        }
        return this.client.findUserFromSSOToken(ssoToken);
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response) throws ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException {
        CookieConfiguration cookieConfig = this.client.getCookieConfiguration();
        String ssoToken = this.tokenHelper.getCrowdToken(request, this.getCookieTokenKey(cookieConfig));
        if (ssoToken != null && !ssoToken.isEmpty()) {
            this.client.invalidateSSOToken(ssoToken);
        }
        this.tokenHelper.removeCrowdToken(request, response, this.clientProperties, cookieConfig);
    }

    @Override
    public String getToken(HttpServletRequest request) {
        return this.tokenHelper.getCrowdToken(request, this.getCookieTokenKey());
    }

    private String getCookieTokenKey(CookieConfiguration config) {
        return this.clientProperties.getCookieTokenKey(config.getName());
    }

    private String getCookieTokenKey() {
        String configuredKey = this.clientProperties.getCookieTokenKey(null);
        if (configuredKey != null) {
            return configuredKey;
        }
        try {
            return this.client.getCookieConfiguration().getName();
        }
        catch (CrowdException e) {
            LOGGER.info("Failed to get cookie configuration from remote Crowd", (Throwable)e);
            return this.clientProperties.getCookieTokenKey();
        }
        catch (ApplicationPermissionException e) {
            LOGGER.info("Failed to get cookie configuration from remote Crowd", (Throwable)e);
            return this.clientProperties.getCookieTokenKey();
        }
    }

    protected boolean shouldRevalidateSession(HttpServletRequest request) {
        Date lastValidation;
        HttpSession session = request.getSession(false);
        if (session == null || this.clientProperties.getSessionValidationInterval() == 0L) {
            return true;
        }
        try {
            lastValidation = (Date)session.getAttribute(this.clientProperties.getSessionLastValidation());
        }
        catch (IllegalStateException e) {
            return true;
        }
        if (lastValidation != null) {
            long timeSpread = lastValidation.getTime() + TimeUnit.MINUTES.toMillis(this.clientProperties.getSessionValidationInterval());
            return timeSpread <= System.currentTimeMillis();
        }
        return true;
    }
}

