/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.DirectoryWrapper;
import com.atlassian.crowd.embedded.api.Directory;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;

public class LazyAttributesEvaluationDirectory
extends DirectoryWrapper
implements Directory {
    private final Set<String> lazyEvaluatedKeys;
    private final UnaryOperator<String> transformer;
    private final Map<String, Optional<String>> evaluatedAttributes;

    public LazyAttributesEvaluationDirectory(Directory delegate, Set<String> lazyEvaluatedKeys, UnaryOperator<String> transformer) {
        super(delegate);
        this.lazyEvaluatedKeys = Collections.unmodifiableSet(new HashSet<String>(lazyEvaluatedKeys));
        this.transformer = transformer;
        this.evaluatedAttributes = new ConcurrentHashMap<String, Optional<String>>();
    }

    @Override
    @Nullable
    public Set<String> getValues(String key) {
        if (this.lazyEvaluatedKeys.contains(key)) {
            return this.evaluatedAttributes.computeIfAbsent(key, this::extractFromDelegateAndTransform).map(Collections::singleton).orElse(null);
        }
        return this.delegate.getValues(key);
    }

    @Override
    @Nullable
    public String getValue(String key) {
        if (this.lazyEvaluatedKeys.contains(key)) {
            return this.evaluatedAttributes.computeIfAbsent(key, this::extractFromDelegateAndTransform).orElse(null);
        }
        return this.delegate.getValue(key);
    }

    @Override
    public Map<String, String> getAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>(this.delegate.getAttributes());
        this.lazyEvaluatedKeys.stream().filter(attributes::containsKey).forEach(k -> attributes.put((String)k, this.getValue((String)k)));
        return attributes;
    }

    private Optional<String> extractFromDelegateAndTransform(String key) {
        Set originalValues = this.delegate.getValues(key);
        if (originalValues == null || originalValues.isEmpty()) {
            return Optional.empty();
        }
        String value = (String)originalValues.iterator().next();
        return Optional.of((String)this.transformer.apply(value));
    }
}

