/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.password.constraint;

import com.atlassian.crowd.directory.AbstractInternalDirectory;
import com.atlassian.crowd.directory.password.constraint.CharacterClassConstraint;
import com.atlassian.crowd.directory.password.constraint.PasswordConstraintsLoader;
import com.atlassian.crowd.directory.password.constraint.PasswordLengthConstraint;
import com.atlassian.crowd.directory.password.constraint.PasswordScoreConstraint;
import com.atlassian.crowd.directory.password.constraint.RegexConstraint;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.PasswordConstraint;
import com.atlassian.crowd.embedded.api.PasswordScore;
import com.atlassian.crowd.embedded.api.PasswordScoreService;
import com.atlassian.crowd.exception.InvalidCharacterClassConstraintException;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalDirectoryPasswordConstraintsLoader
implements PasswordConstraintsLoader {
    private static final Logger logger = LoggerFactory.getLogger(InternalDirectoryPasswordConstraintsLoader.class);
    private final PasswordScoreService passwordScoreService;

    public InternalDirectoryPasswordConstraintsLoader(PasswordScoreService passwordScoreService) {
        this.passwordScoreService = passwordScoreService;
    }

    @Override
    public Set<PasswordConstraint> getFromDirectoryAttributes(long directoryId, Attributes attributes) {
        String regex;
        PasswordScore minimumPasswordScore;
        HashSet<Object> setBuilder = new HashSet<Object>();
        String minimumLength = attributes.getValue("password_minimum_length");
        if (minimumLength != null) {
            setBuilder.add(new PasswordLengthConstraint(Integer.parseInt(minimumLength)));
        }
        if ((minimumPasswordScore = this.getMinimumPasswordScore(directoryId, attributes)) != null) {
            setBuilder.add(new PasswordScoreConstraint(minimumPasswordScore, this.passwordScoreService));
        }
        if ((regex = attributes.getValue("password_regex")) != null) {
            setBuilder.add(new RegexConstraint(regex));
        }
        if (this.areCharacterClassConstraintAttributesPresent(attributes)) {
            try {
                CharacterClassConstraint characterClassConstraint = this.buildCharacterClassConstraint(attributes);
                setBuilder.add(characterClassConstraint);
            }
            catch (InvalidCharacterClassConstraintException e) {
                logger.error("Failed to build character class constraint from directory attributes. The password currently being set may not adhere to current password policy", (Throwable)e);
            }
        }
        return Collections.unmodifiableSet(setBuilder);
    }

    @Nullable
    private PasswordScore getMinimumPasswordScore(long directoryId, Attributes attributes) {
        String scoreRanking = attributes.getValue("password_minimum_score");
        if (scoreRanking == null) {
            return null;
        }
        try {
            return PasswordScore.fromRanking((long)Long.parseLong(scoreRanking));
        }
        catch (IllegalArgumentException e) {
            logger.error("An invalid ranking for password score of {} was found in the database for directory {}", (Object)scoreRanking, (Object)directoryId);
            return null;
        }
    }

    private boolean areCharacterClassConstraintAttributesPresent(Attributes attributes) {
        return AbstractInternalDirectory.CHARACTER_CLASS_CONSTRAINT_ATTRIBUTES.stream().anyMatch(attributeKey -> attributes.getValue(attributeKey) != null);
    }

    private CharacterClassConstraint buildCharacterClassConstraint(Attributes attributes) {
        return CharacterClassConstraint.builder().minimumLowercase(attributes.getValue("password_minimum_lowercase")).minimumUppercase(attributes.getValue("password_minimum_uppercase")).minimumDigits(attributes.getValue("password_minimum_digits")).minimumSpecialCharacters(attributes.getValue("password_minimum_special_characters")).minimumRulesMatched(attributes.getValue("password_minimum_rules_matched")).build();
    }
}

