/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.secret;

import com.atlassian.secrets.api.SealedSecret;
import java.util.Objects;

public class SealedSecretEntity {
    private String identifier;
    private String backendId;
    private String sealedValue;

    public SealedSecretEntity() {
    }

    public SealedSecretEntity(SealedSecret sealedSecret) {
        this.identifier = sealedSecret.getIdentifier();
        this.backendId = sealedSecret.getBackendId();
        this.sealedValue = sealedSecret.toString();
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setBackendId(String backendId) {
        this.backendId = backendId;
    }

    public void setSealedValue(String sealedValue) {
        this.sealedValue = sealedValue;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getBackendId() {
        return this.backendId;
    }

    public String getSealedValue() {
        return this.sealedValue;
    }

    public SealedSecret toSealedSecret() {
        return SealedSecret.from((String)this.sealedValue);
    }

    public String toString() {
        return "SealedSecretEntity{, identifier='" + this.identifier + "', backendId='" + this.backendId + "', sealedValue='" + this.sealedValue + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SealedSecretEntity that = (SealedSecretEntity)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.backendId, that.backendId) && Objects.equals(this.sealedValue, that.sealedValue);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.backendId, this.sealedValue);
    }
}

