/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.crowd.embedded.api.service.ServiceAccount;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.service.InternalServiceAccount;
import com.atlassian.crowd.model.service.InternalServiceAccountAuthMethod;
import com.atlassian.crowd.model.service.ResourceRestriction;
import com.atlassian.crowd.util.ResourceRestrictionSetTransformer;
import java.util.HashSet;
import java.util.Set;

public class ServiceAccountDAOMapper {
    public static InternalServiceAccount toServiceAccountDAOInput(ServiceAccount serviceAccount) {
        return ServiceAccountDAOMapper.toServiceAccount(serviceAccount, null, null);
    }

    public static InternalServiceAccount toServiceAccountDAOInput(ServiceAccount serviceAccount, Set<InternalServiceAccountAuthMethod> authMethods) {
        return ServiceAccountDAOMapper.toServiceAccount(serviceAccount, null, authMethods);
    }

    public static InternalServiceAccount toServiceAccountDAO(ServiceAccount serviceAccount) {
        return ServiceAccountDAOMapper.toServiceAccount(serviceAccount, serviceAccount.getId(), null);
    }

    public static InternalServiceAccount toServiceAccountDAO(ServiceAccount serviceAccount, Set<InternalServiceAccountAuthMethod> authMethods) {
        return ServiceAccountDAOMapper.toServiceAccount(serviceAccount, serviceAccount.getId(), authMethods);
    }

    private static InternalServiceAccount toServiceAccount(ServiceAccount serviceAccount, Long id, Set<InternalServiceAccountAuthMethod> authMethods) {
        InternalServiceAccount internalServiceAccount = new InternalServiceAccount(id, serviceAccount.isActive(), serviceAccount.getName(), IdentifierUtils.toLowerCase((String)serviceAccount.getName()), serviceAccount.getDisplayName(), serviceAccount.getDescription(), new HashSet<ResourceRestriction>(), authMethods);
        if (id != null && serviceAccount.getResourceRestrictions() != null) {
            Set<ResourceRestriction> resourceRestrictions = ResourceRestrictionSetTransformer.fromMap(serviceAccount.getResourceRestrictions(), internalServiceAccount);
            internalServiceAccount.setResourceRestrictions(resourceRestrictions);
        }
        return internalServiceAccount;
    }
}

