/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.csp.internal;

import com.atlassian.security.csp.api.internal.NonceService;
import com.atlassian.security.random.SecureTokenGenerator;

public class DefaultCspNonceService
implements NonceService {
    private final ThreadLocal<String> nonceHolder = new ThreadLocal();
    private final SecureTokenGenerator tokenGenerator;

    public DefaultCspNonceService(SecureTokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    public String getNonce() {
        String nonce = this.nonceHolder.get();
        if (nonce == null) {
            nonce = this.tokenGenerator.generateNonce();
            this.nonceHolder.set(nonce);
        }
        return nonce;
    }

    public void clearNonce() {
        this.nonceHolder.remove();
    }
}

