/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.serialblocklist;

import com.atlassian.security.serialblocklist.ArrayDimensionLimitException;
import com.atlassian.security.serialblocklist.BlockedPattern;
import java.io.ObjectInputFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlocklistFilteringFunction
implements Predicate<Class<?>>,
Function<Class<?>, ObjectInputFilter.Status> {
    private static final Logger log = LoggerFactory.getLogger(BlocklistFilteringFunction.class);
    private static final int MAX_ARRAY_DIMENSIONS = 255;
    private final Set<String> blockedClassesNames;
    private final Set<String> blockedNestedClassesPrefixes;
    private final List<BlockedPattern> blockedPatterns;
    private final Set<Class<?>> blockedClasses;

    public BlocklistFilteringFunction(Set<String> blockedClasses, List<BlockedPattern> blockedPatterns) {
        this.blockedClassesNames = new HashSet<String>(Optional.ofNullable(blockedClasses).orElseGet(Collections::emptySet));
        this.blockedClasses = this.blockedClassesNames.stream().map(this::getClass).filter(Objects::nonNull).collect(Collectors.toSet());
        this.blockedPatterns = new ArrayList<BlockedPattern>(Optional.ofNullable(blockedPatterns).orElseGet(Collections::emptyList));
        this.blockedNestedClassesPrefixes = this.blockedClassesNames.stream().map(cn -> cn + "$").collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public boolean test(Class<?> rawClass) {
        return ObjectInputFilter.Status.ALLOWED == this.apply(rawClass);
    }

    @Override
    public ObjectInputFilter.Status apply(Class<?> rawClass) {
        if (rawClass == null) {
            return ObjectInputFilter.Status.ALLOWED;
        }
        try {
            Class<?> actualClass = BlocklistFilteringFunction.getActualClass(rawClass);
            if (actualClass.isPrimitive()) {
                return ObjectInputFilter.Status.ALLOWED;
            }
            if (this.checkClassName(actualClass.getName()) && this.checkPattern(rawClass) && this.checkChildClass(BlocklistFilteringFunction.getActualClass(rawClass)) && this.checkNestedClass(actualClass.getName())) {
                return ObjectInputFilter.Status.ALLOWED;
            }
        }
        catch (ArrayDimensionLimitException e) {
            log.error("Error while checking class: {}", (Object)rawClass.getName(), (Object)e);
        }
        log.warn("Deserialize or execute step prevented for class: {}", (Object)rawClass.getName());
        return ObjectInputFilter.Status.REJECTED;
    }

    static Class<?> getActualClass(Class<?> rawClass) {
        return BlocklistFilteringFunction.getActualClass(rawClass, 0);
    }

    static Class<?> getActualClass(Class<?> rawClass, int limit) {
        if (limit >= 255) {
            throw new ArrayDimensionLimitException("Array dimension limit exceeded");
        }
        return rawClass.isArray() ? BlocklistFilteringFunction.getActualClass(rawClass.getComponentType(), ++limit) : rawClass;
    }

    boolean checkClassName(String className) {
        return !this.blockedClassesNames.contains(className);
    }

    boolean checkChildClass(Class<?> actualClass) {
        return this.blockedClasses.stream().filter(Objects::nonNull).noneMatch(blockedClass -> blockedClass.isAssignableFrom(actualClass));
    }

    boolean checkNestedClass(String actualClassName) {
        for (String prefix : this.blockedNestedClassesPrefixes) {
            if (!actualClassName.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    boolean checkPattern(Class<?> rawClass) {
        if (rawClass.isInterface()) {
            return true;
        }
        Class<?> actualClass = BlocklistFilteringFunction.getActualClass(rawClass);
        for (BlockedPattern pattern : this.blockedPatterns) {
            if (!this.matchPattern(pattern, actualClass)) continue;
            return false;
        }
        return true;
    }

    private Class<?> getClass(String clazz) {
        try {
            return Class.forName(clazz, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    private boolean matchPattern(BlockedPattern pattern, Class<?> actualClass) {
        if (pattern.isEmpty()) {
            return false;
        }
        boolean isPatternMatch = true;
        if (!pattern.regexes().isEmpty()) {
            isPatternMatch = this.matchesRegex(pattern, actualClass.getName());
        }
        if (isPatternMatch && !pattern.parentClasses().isEmpty()) {
            isPatternMatch = this.matchesParentClass(pattern, actualClass);
        }
        return isPatternMatch;
    }

    private boolean matchesParentClass(BlockedPattern pattern, Class<?> rawClass) {
        for (Class<?> cls = rawClass; cls != null && cls != Object.class; cls = cls.getSuperclass()) {
            String superClassName = cls.getSimpleName();
            if (!pattern.parentClasses().contains(superClassName)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesRegex(BlockedPattern pattern, String className) {
        for (Pattern regex : pattern.regexes()) {
            if (!regex.matcher(className).matches()) continue;
            return true;
        }
        return false;
    }
}

