/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.integration.jira.web;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.integration.jira.JiraIssueUrlsRequest;
import com.atlassian.integration.jira.JiraService;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import java.util.Set;

public class ShouldDisplayIssueSectionCondition
implements Condition {
    private final JiraService jiraService;

    public ShouldDisplayIssueSectionCondition(JiraService jiraService) {
        this.jiraService = jiraService;
    }

    public void init(Map<String, String> initParams) {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.jiraService.isLinked() && this.hasJiraKeys(context);
    }

    private boolean hasJiraKeys(Map<String, Object> context) {
        Commit commit = (Commit)context.get("commit");
        if (commit == null) {
            return true;
        }
        Set issueKeys = (Set)commit.getProperties().get((Object)"jira-key");
        if (issueKeys == null || issueKeys.isEmpty()) {
            return false;
        }
        if (issueKeys.size() > 1) {
            return true;
        }
        Map urls = this.jiraService.getIssueUrls(((JiraIssueUrlsRequest.Builder)new JiraIssueUrlsRequest.Builder().issueKeys((Iterable)issueKeys)).build());
        return !urls.isEmpty();
    }
}

