/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.integration.jira;

import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityLinkService;
import com.atlassian.applinks.api.application.jira.JiraProjectEntityType;
import com.atlassian.bitbucket.internal.integration.jira.InternalEnhancedEntityLinkService;
import com.atlassian.bitbucket.internal.integration.jira.model.EnhancedEntityLink;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEnhancedEntityLinkService
implements InternalEnhancedEntityLinkService {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String PROJECT_ID = "projectId";
    private static final Logger log = LoggerFactory.getLogger(DefaultEnhancedEntityLinkService.class);
    private final EntityLinkService entityLinkService;

    public DefaultEnhancedEntityLinkService(EntityLinkService entityLinkService) {
        this.entityLinkService = entityLinkService;
    }

    @Override
    @Nonnull
    public Optional<EnhancedEntityLink> findPrimaryJiraLinkByProject(@Nonnull Project project) {
        return this.getPrimaryEntityLink(project).flatMap(link -> Optional.ofNullable(this.retrieveProjectId((EntityLink)link)).map(projectId -> new EnhancedEntityLink.Builder((EntityLink)link, (long)projectId).build()));
    }

    private Optional<EntityLink> getPrimaryEntityLink(Project project) {
        return Optional.ofNullable(this.entityLinkService.getPrimaryEntityLink((Object)Objects.requireNonNull(project, "project"), JiraProjectEntityType.class));
    }

    private Long requestProjectId(EntityLink link) {
        try {
            Long projectId = (Long)((ApplicationLinkRequest)link.getApplicationLink().createImpersonatingAuthenticatedRequestFactory().createRequest(Request.MethodType.GET, "/rest/api/2/project/" + link.getKey()).setHeader("Content-Type", "application/json")).execute((ApplicationLinkResponseHandler)new ProjectIdResponseHandler());
            link.putProperty(PROJECT_ID, (Object)String.valueOf(projectId));
            return projectId;
        }
        catch (CredentialsRequiredException | ResponseException e) {
            log.warn("Cannot retrieve projectId because following error occurred", e);
            return null;
        }
    }

    private Long retrieveProjectId(EntityLink link) {
        return Optional.ofNullable(link.getProperty(PROJECT_ID)).map(p -> Long.parseLong((String)p)).orElseGet(() -> this.requestProjectId(link));
    }

    @VisibleForTesting
    static class ProjectIdResponseHandler
    implements ApplicationLinkResponseHandler<Long> {
        ProjectIdResponseHandler() {
        }

        public Long credentialsRequired(Response response) {
            log.warn("User is not authenticated to the primary linked jira instance, not returning projectId");
            return null;
        }

        public Long handle(Response response) throws ResponseException {
            if (response.isSuccessful()) {
                try {
                    return OBJECT_MAPPER.readTree(response.getResponseBodyAsString()).get("id").longValue();
                }
                catch (IOException e) {
                    log.warn("Unable to unmarshall projectId because", (Throwable)e);
                }
            } else {
                log.warn("Cannot retrieve projectId because of: {}", (Object)response.getStatusText());
            }
            return null;
        }
    }
}

