/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.integration.jira;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentableVisitor;
import com.atlassian.bitbucket.commit.AbstractCommitCallback;
import com.atlassian.bitbucket.commit.Changeset;
import com.atlassian.bitbucket.commit.ChangesetsRequest;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentDeletedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentDeletedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.idx.CommitIndex;
import com.atlassian.bitbucket.idx.IndexedCommit;
import com.atlassian.bitbucket.integration.jira.CommentJiraIssue;
import com.atlassian.bitbucket.integration.jira.JiraIssue;
import com.atlassian.bitbucket.internal.integration.jira.InternalJiraIssueService;
import com.atlassian.bitbucket.internal.integration.jira.JiraCreateIssueException;
import com.atlassian.bitbucket.internal.integration.jira.analytics.AnalyticsCreateJiraIssueForCommentFailedEvent;
import com.atlassian.bitbucket.internal.integration.jira.analytics.AnalyticsCreateJiraIssueForCommentSucceededEvent;
import com.atlassian.bitbucket.internal.integration.jira.dao.CommentJiraIssueDao;
import com.atlassian.bitbucket.internal.integration.jira.idx.JiraCommitPropertyConfiguration;
import com.atlassian.bitbucket.internal.integration.jira.model.SimpleJiraIssue;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.property.PropertyMap;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitsRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageImpl;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.RequestLocalMap;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.integration.jira.JiraIssueUrlsRequest;
import com.atlassian.integration.jira.JiraKeyScanner;
import com.atlassian.integration.jira.JiraService;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJiraIssueService
implements InternalJiraIssueService {
    private static final int DEFAULT_MAX_COMMITS = 100;
    private static final String KEY_LINKED = "__linked";
    private static final String PROP_MAX_COMMITS = "plugin.jira-integration.pullrequest.attribute.commits.max";
    private static final int MAX_MAX_COMMITS = 1000;
    private static final int MIN_MAX_COMMITS = 50;
    private static final Logger log = LoggerFactory.getLogger(DefaultJiraIssueService.class);
    private final AuthenticationContext authenticationContext;
    private final CommitIndex commitIndex;
    private final CommentJiraIssueDao commentJiraIssueDao;
    private final CommitService commitService;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final JiraKeyScanner jiraKeyScanner;
    private final JiraService jiraService;
    private final PermissionValidationService permissionValidationService;
    private final PullRequestService pullRequestService;
    private final RequestLocalMap<String, Boolean> requestCache;
    private final TransactionTemplate transactionTemplate;
    private final int maxCommits;

    public DefaultJiraIssueService(AuthenticationContext authenticationContext, CommitIndex commitIndex, CommentJiraIssueDao commentJiraIssueDao, CommitService commitService, EventPublisher eventPublisher, I18nService i18nService, JiraKeyScanner jiraKeyScanner, JiraService jiraService, ApplicationPropertiesService propertiesService, PermissionValidationService permissionValidationService, PullRequestService pullRequestService, RequestManager requestManager, TransactionTemplate transactionTemplate) {
        this(authenticationContext, commitIndex, commentJiraIssueDao, commitService, eventPublisher, i18nService, jiraKeyScanner, jiraService, permissionValidationService, pullRequestService, requestManager, transactionTemplate, DefaultJiraIssueService.computeMaxCommits(propertiesService));
    }

    @VisibleForTesting
    DefaultJiraIssueService(AuthenticationContext authenticationContext, CommitIndex commitIndex, CommentJiraIssueDao commentJiraIssueDao, CommitService commitService, EventPublisher eventPublisher, I18nService i18nService, JiraKeyScanner jiraKeyScanner, JiraService jiraService, PermissionValidationService permissionValidationService, PullRequestService pullRequestService, RequestManager requestManager, TransactionTemplate transactionTemplate, int maxCommits) {
        this.authenticationContext = authenticationContext;
        this.commitIndex = commitIndex;
        this.commentJiraIssueDao = commentJiraIssueDao;
        this.commitService = commitService;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.jiraKeyScanner = jiraKeyScanner;
        this.jiraService = jiraService;
        this.maxCommits = maxCommits;
        this.permissionValidationService = permissionValidationService;
        this.pullRequestService = pullRequestService;
        this.transactionTemplate = transactionTemplate;
        this.requestCache = new RequestLocalMap(requestManager);
    }

    @Override
    @Nonnull
    public CommentJiraIssue createIssueForComment(@Nonnull ApplicationId id, @Nonnull Comment comment, @Nonnull String createIssueRequestJson) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(comment, "comment");
        Objects.requireNonNull(createIssueRequestJson, "createIssueRequestJson");
        this.validateForComment(comment);
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode response = objectMapper.readTree(this.jiraService.createIssue(id, createIssueRequestJson));
            if (response.has("errors")) {
                Map<String, String> elementErrors = DefaultJiraIssueService.getElementErrors(response, objectMapper);
                List<String> errorMessages = DefaultJiraIssueService.getErrorMessages(response, objectMapper);
                throw new JiraCreateIssueException(this.i18nService.createKeyedMessage("bitbucket.jira.issue.create.error.response", new Object[0]), elementErrors, errorMessages);
            }
            CommentJiraIssue commentJiraIssue = (CommentJiraIssue)this.transactionTemplate.execute(() -> this.commentJiraIssueDao.create(comment.getId(), DefaultJiraIssueService.getIssueKey(response)));
            this.eventPublisher.publish((Object)new AnalyticsCreateJiraIssueForCommentSucceededEvent(this, comment, currentUser));
            return commentJiraIssue;
        }
        catch (IOException e) {
            log.warn("Error parsing JSON response from Jira server when creating an issue for a comment");
            this.eventPublisher.publish((Object)new AnalyticsCreateJiraIssueForCommentFailedEvent(this, comment, currentUser));
            throw new RuntimeException(this.i18nService.getMessage("bitbucket.jira.issue.create.error.io", new Object[]{e.getLocalizedMessage()}), e);
        }
        catch (IllegalArgumentException e) {
            this.eventPublisher.publish((Object)new AnalyticsCreateJiraIssueForCommentFailedEvent(this, comment, currentUser));
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.jira.issue.create.error.request", new Object[]{e.getLocalizedMessage()}));
        }
        catch (NoSuchElementException e) {
            this.eventPublisher.publish((Object)new AnalyticsCreateJiraIssueForCommentFailedEvent(this, comment, currentUser));
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.jira.issue.create.error.applicationid", new Object[]{id.toString()}));
        }
        catch (Exception e) {
            this.eventPublisher.publish((Object)new AnalyticsCreateJiraIssueForCommentFailedEvent(this, comment, currentUser));
            throw e;
        }
    }

    @Override
    @Nonnull
    public List<JiraIssue> findIssuesByKey(@Nonnull Set<String> issueKeys) {
        Objects.requireNonNull(issueKeys, "issueKeys");
        return this.addSimpleIssues(issueKeys, new ArrayList());
    }

    @Override
    @Nonnull
    public Page<Changeset> getChangesetsForIssue(@Nonnull String issueKey, int maxChanges, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(issueKey, "issueKey");
        Objects.requireNonNull(pageRequest, "pageRequest");
        Page commits = this.commitIndex.findByProperty("jira-key", issueKey.toUpperCase(Locale.US), true, pageRequest);
        if (commits.getSize() == 0) {
            return PageUtils.createEmptyPage((PageRequest)pageRequest);
        }
        HashMap changesetsById = new HashMap();
        this.getCommitsToQueryPerRepository((Page<IndexedCommit>)commits).entrySet().stream().map(entry -> this.commitService.getChangesets(new ChangesetsRequest.Builder((Repository)entry.getKey()).commitIds((Iterable)entry.getValue()).maxChangesPerCommit(maxChanges).ignoreMissing(true).build(), PageUtils.newRequest((int)0, (int)((Set)entry.getValue()).size()))).flatMap(Page::stream).forEach(changeset -> changesetsById.put(changeset.getToCommit().getId(), changeset));
        ArrayList changesets = new ArrayList(commits.getSize());
        commits.stream().map(IndexedCommit::getId).map(changesetsById::get).filter(Objects::nonNull).forEach(changesets::add);
        PageRequest nextPage = commits.getNextPageRequest();
        return new PageImpl(pageRequest, changesets, nextPage == null, changesets.size(), nextPage == null ? 0 : nextPage.getStart());
    }

    @Override
    @Nonnull
    public Map<Long, Set<String>> getIssuesForComments(@Nonnull Set<Long> commentIds) {
        Objects.requireNonNull(commentIds, "commentIds");
        return (Map)this.transactionTemplate.execute(() -> this.commentJiraIssueDao.findByCommentIds(commentIds));
    }

    @Override
    @Nonnull
    public Set<JiraIssue> getIssuesForCommits(@Nonnull Set<String> commitIds) {
        return this.getIssuesIfLinked(() -> {
            Iterable ids = Objects.requireNonNull(commitIds, "commitIds");
            int commitCount = commitIds.size();
            if (commitCount > this.maxCommits) {
                log.warn("Limiting the first {} commits out of {}", (Object)this.maxCommits, (Object)commitCount);
                ids = Iterables.limit((Iterable)ids, (int)this.maxCommits);
            }
            return this.findIssuesForCommits(ids);
        });
    }

    @Override
    @Nonnull
    public Set<JiraIssue> getIssuesForPullRequest(final int repositoryId, final long pullRequestId) {
        return this.getIssuesIfLinked((Supplier<? extends Iterable<String>>)new Supplier<Iterable<String>>(){

            @Override
            public Iterable<String> get() {
                Set<String> issuesFromCommits = DefaultJiraIssueService.this.findIssuesForCommits(this.getCommits());
                PullRequest pullRequest = DefaultJiraIssueService.this.pullRequestService.getById(repositoryId, pullRequestId);
                if (pullRequest == null) {
                    return issuesFromCommits;
                }
                return Iterables.concat(issuesFromCommits, this.scanIssuesForPullRequest(pullRequest));
            }

            private Set<String> getCommits() {
                final LinkedHashSet<String> commitIds = new LinkedHashSet<String>();
                DefaultJiraIssueService.this.pullRequestService.streamCommits(new PullRequestCommitsRequest.Builder(repositoryId, pullRequestId).maxMessageLength(0).build(), (CommitCallback)new AbstractCommitCallback(){

                    public boolean onCommit(@Nonnull Commit commit) {
                        commitIds.add(commit.getId());
                        return commitIds.size() < DefaultJiraIssueService.this.maxCommits;
                    }
                });
                return commitIds;
            }

            private Iterable<String> scanIssuesForPullRequest(PullRequest pullRequest) {
                return Iterables.concat((Iterable)DefaultJiraIssueService.this.jiraKeyScanner.findAll((CharSequence)pullRequest.getTitle()), (Iterable)DefaultJiraIssueService.this.jiraKeyScanner.findAll((CharSequence)pullRequest.getFromRef().getId()));
            }
        });
    }

    @Override
    public boolean isLinked() {
        return (Boolean)this.requestCache.get((Object)KEY_LINKED, () -> ((JiraService)this.jiraService).isLinked());
    }

    @EventListener
    public void onCommitDiscussionCommentDeleted(@Nonnull CommitDiscussionCommentDeletedEvent event) {
        this.transactionTemplate.execute(() -> {
            this.commentJiraIssueDao.deleteByCommentId(event.getComment().getId());
            return null;
        });
    }

    @EventListener
    public void onPullRequestCommentDeleted(@Nonnull PullRequestCommentDeletedEvent event) {
        this.transactionTemplate.execute(() -> {
            this.commentJiraIssueDao.deleteByCommentId(event.getComment().getId());
            return null;
        });
    }

    private static int computeMaxCommits(ApplicationPropertiesService propertiesService) {
        int maxCommits = propertiesService.getPluginProperty(PROP_MAX_COMMITS, 100);
        if (maxCommits < 50) {
            maxCommits = 50;
        } else if (maxCommits > 1000) {
            maxCommits = 1000;
        }
        return maxCommits;
    }

    private static Map<String, String> getElementErrors(JsonNode response, ObjectMapper objectMapper) {
        TypeReference<Map<String, String>> typeRef = new TypeReference<Map<String, String>>(){};
        JsonNode elementErrors = response.get("errors").get(0).get("elementErrors").get("errors");
        return (Map)objectMapper.convertValue((Object)elementErrors, (TypeReference)typeRef);
    }

    private static List<String> getErrorMessages(JsonNode response, ObjectMapper objectMapper) {
        TypeReference<List<String>> typeRef = new TypeReference<List<String>>(){};
        JsonNode errorMessages = response.get("errors").get(0).get("elementErrors").get("errorMessages");
        return (List)objectMapper.convertValue((Object)errorMessages, (TypeReference)typeRef);
    }

    private static String getIssueKey(JsonNode response) {
        return response.get("issues").get(0).get("issue").get("key").asText();
    }

    private Map<Repository, Set<String>> getCommitsToQueryPerRepository(Page<IndexedCommit> page) {
        LinkedHashMap<Repository, Set<String>> commitsByRepository = new LinkedHashMap<Repository, Set<String>>();
        HashSet processedCommits = new HashSet();
        page.stream().filter(commit -> commit.getRepositories().size() == 1).forEach(commit -> {
            Repository repository = (Repository)Iterables.getFirst((Iterable)commit.getRepositories(), null);
            commitsByRepository.computeIfAbsent(repository, r -> new HashSet()).add(commit.getId());
            processedCommits.add(commit.getId());
        });
        page.stream().filter(commit -> !processedCommits.contains(commit.getId())).forEach(commit -> {
            Optional<Set> commitIds = commit.getRepositories().stream().map(commitsByRepository::get).filter(Objects::nonNull).findFirst();
            if (commitIds.isPresent()) {
                commitIds.get().add(commit.getId());
            } else {
                commitsByRepository.put((Repository)Iterables.getFirst((Iterable)commit.getRepositories(), null), Sets.newHashSet((Object[])new String[]{commit.getId()}));
            }
            processedCommits.add(commit.getId());
        });
        return commitsByRepository;
    }

    private Set<JiraIssue> getIssuesIfLinked(Supplier<? extends Iterable<String>> keys) {
        if (this.isLinked()) {
            return this.addSimpleIssues(keys.get(), new LinkedHashSet());
        }
        log.debug("{} has not been linked to Jira", (Object)Product.NAME);
        return Collections.emptySet();
    }

    private Set<String> findIssuesForCommits(Iterable<String> commitIds) {
        TreeSet<String> issueKeys = new TreeSet<String>();
        for (PropertyMap properties : this.commitIndex.getProperties(commitIds, JiraCommitPropertyConfiguration.ISSUE_KEYS).values()) {
            issueKeys.addAll((Set)properties.get((Object)"jira-key"));
        }
        return issueKeys;
    }

    private <T extends Collection<JiraIssue>> T addSimpleIssues(Iterable<String> issueKeys, T issues) {
        if (issueKeys == null || Iterables.isEmpty(issueKeys)) {
            return issues;
        }
        Map urls = this.jiraService.getIssueUrls(((JiraIssueUrlsRequest.Builder)new JiraIssueUrlsRequest.Builder().issueKeys(issueKeys)).build());
        for (String issueKey : issueKeys) {
            String url = (String)urls.get(issueKey);
            if (url == null) continue;
            SimpleJiraIssue issue = SimpleJiraIssue.maybeCreate(issueKey, url);
            if (issue == null) {
                log.debug("Could not instantiate a Jira issue with key '{}' and url '{}'; ignoring", (Object)issueKey, (Object)url);
                continue;
            }
            issues.add((SimpleJiraIssue)issue);
        }
        return issues;
    }

    private void validateForComment(Comment comment) {
        Repository repository = (Repository)comment.getThread().getCommentable().accept((CommentableVisitor)new CommentableVisitor<Repository>(this){

            public Repository visit(@Nonnull CommitDiscussion discussion) {
                return discussion.getRepository();
            }

            public Repository visit(@Nonnull PullRequest pullRequest) {
                return pullRequest.getToRef().getRepository();
            }
        });
        this.permissionValidationService.validateForRepository(repository, Permission.REPO_READ);
    }
}

