/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.integration.jira.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.internal.integration.jira.event.CreateJiraIssueForCommentFailedEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@AsynchronousPreferred
@EventName(value="stash.jira.issue.comment.create.fail")
public class AnalyticsCreateJiraIssueForCommentFailedEvent
extends CreateJiraIssueForCommentFailedEvent {
    private final PullRequest pullRequest;
    private final Repository repository;
    private final String userRole;

    public AnalyticsCreateJiraIssueForCommentFailedEvent(@Nonnull Object source, @Nonnull Comment comment, @Nullable ApplicationUser user) {
        super(source, comment);
        this.pullRequest = AnalyticsCreateJiraIssueForCommentFailedEvent.getPullRequestFromComment(comment);
        this.repository = AnalyticsCreateJiraIssueForCommentFailedEvent.getRepositoryFromComment(comment);
        this.userRole = AnalyticsCreateJiraIssueForCommentFailedEvent.getRoleFromPullRequest(this.pullRequest, user);
    }

    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getUserRole() {
        return this.userRole;
    }
}

