/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.integration.jira.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.internal.integration.jira.event.CreateJiraIssueForCommentSucceededEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@AsynchronousPreferred
@EventName(value="stash.jira.issue.comment.create.success")
public class AnalyticsCreateJiraIssueForCommentSucceededEvent
extends CreateJiraIssueForCommentSucceededEvent {
    private final PullRequest pullRequest;
    private final Repository repository;
    private final String userRole;

    public AnalyticsCreateJiraIssueForCommentSucceededEvent(@Nonnull Object source, @Nonnull Comment comment, @Nullable ApplicationUser user) {
        super(source, comment);
        this.pullRequest = AnalyticsCreateJiraIssueForCommentSucceededEvent.getPullRequestFromComment(comment);
        this.repository = AnalyticsCreateJiraIssueForCommentSucceededEvent.getRepositoryFromComment(comment);
        this.userRole = AnalyticsCreateJiraIssueForCommentSucceededEvent.getRoleFromPullRequest(this.pullRequest, user);
    }

    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getUserRole() {
        return this.userRole;
    }
}

