/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.integration.jira.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.integration.jira.CommentJiraIssue;
import com.atlassian.bitbucket.internal.integration.jira.dao.AoCommentJiraIssue;
import com.atlassian.bitbucket.internal.integration.jira.dao.CommentJiraIssueDao;
import com.atlassian.bitbucket.internal.integration.jira.model.SimpleCommentJiraIssue;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AoCommentJiraIssueDao
extends AbstractAoDao
implements CommentJiraIssueDao {
    public static final int DEFAULT_MAX_COMMENT_ISSUES = 500;
    public static final String PROPERTY_MAX_COMMENT_ISSUES = "plugin.jira-integration.comment.issues.max";
    private static final int IN_CLAUSE_LIMIT = 100;
    private static final Logger log = LoggerFactory.getLogger(AoCommentJiraIssueDao.class);
    private final int maxCommentIssues;

    public AoCommentJiraIssueDao(ActiveObjects ao, ApplicationPropertiesService applicationPropertiesService) {
        super(ao);
        this.maxCommentIssues = applicationPropertiesService.getPluginProperty(PROPERTY_MAX_COMMENT_ISSUES, 500);
    }

    @Override
    @Nonnull
    public CommentJiraIssue create(long commentId, @Nonnull String issueKey) {
        AoCommentJiraIssue commentJiraIssue = (AoCommentJiraIssue)this.ao.create(AoCommentJiraIssue.class, (Map)ImmutableMap.of((Object)"COMMENT_ID", (Object)commentId, (Object)"ISSUE_KEY", (Object)issueKey));
        return new SimpleCommentJiraIssue(commentJiraIssue.getCommentId(), commentJiraIssue.getIssueKey());
    }

    @Override
    public void deleteByCommentId(long commentId) {
        this.ao.deleteWithSQL(AoCommentJiraIssue.class, "COMMENT_ID = ?", new Object[]{commentId});
    }

    @Override
    @Nonnull
    public Map<Long, Set<String>> findByCommentIds(@Nonnull Set<Long> commentIds) {
        ArrayList<AoCommentJiraIssue> commentJiraIssues = new ArrayList<AoCommentJiraIssue>();
        for (List commentIdsBatch : Iterables.partition(commentIds, (int)100)) {
            commentJiraIssues.addAll(this.findByCommentIdsInternal(commentIdsBatch));
            if (commentJiraIssues.size() < this.maxCommentIssues) continue;
            log.debug("Maximum request limit of {} issues reached when requesting Jira issues associated with comment IDs {}, results may be incomplete", (Object)this.maxCommentIssues, commentIds);
            break;
        }
        HashMap result = new HashMap();
        commentJiraIssues.forEach(commentJiraIssue -> result.computeIfAbsent(commentJiraIssue.getCommentId(), commentId -> ImmutableSet.builder()).add((Object)commentJiraIssue.getIssueKey()));
        Sets.difference(commentIds, result.keySet()).forEach(commentId -> result.put(commentId, ImmutableSet.builder()));
        return (Map)result.entrySet().stream().collect(MoreCollectors.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableSet.Builder)entry.getValue()).build()));
    }

    private List<AoCommentJiraIssue> findByCommentIdsInternal(List<Long> commentIds) {
        Query query = Query.select().where("COMMENT_ID IN (" + Collections.nCopies(commentIds.size(), "?").stream().collect(Collectors.joining(",")) + ")", commentIds.toArray()).limit(this.maxCommentIssues);
        return ImmutableList.copyOf((Object[])((AoCommentJiraIssue[])this.ao.find(AoCommentJiraIssue.class, query)));
    }
}

