/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.integration.jira.event;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentableVisitor;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.stream.Stream;

@TransactionAware
public abstract class CreateJiraIssueForCommentEvent
extends ApplicationEvent {
    private static final String NO_PULL_REQUEST_ROLE = "other";
    private final Comment comment;

    protected CreateJiraIssueForCommentEvent(@Nonnull Object source, @Nonnull Comment comment) {
        super(source);
        this.comment = Objects.requireNonNull(comment, "comment");
    }

    @Nonnull
    public Comment getComment() {
        return this.comment;
    }

    protected static PullRequest getPullRequestFromComment(Comment comment) {
        return (PullRequest)comment.getThread().getCommentable().accept((CommentableVisitor)new CommentableVisitor<PullRequest>(){

            public PullRequest visit(@Nonnull CommitDiscussion discussion) {
                return null;
            }

            public PullRequest visit(@Nonnull PullRequest pullRequest) {
                return pullRequest;
            }
        });
    }

    protected static Repository getRepositoryFromComment(Comment comment) {
        return (Repository)comment.getThread().getCommentable().accept((CommentableVisitor)new CommentableVisitor<Repository>(){

            public Repository visit(@Nonnull CommitDiscussion discussion) {
                return discussion.getRepository();
            }

            public Repository visit(@Nonnull PullRequest pullRequest) {
                return pullRequest.getToRef().getRepository();
            }
        });
    }

    protected static String getRoleFromPullRequest(PullRequest pullRequest, ApplicationUser user) {
        if (user == null) {
            return NO_PULL_REQUEST_ROLE;
        }
        if (user.getSlug().equals(pullRequest.getAuthor().getUser().getSlug())) {
            return PullRequestRole.AUTHOR.name().toLowerCase();
        }
        return Stream.concat(pullRequest.getReviewers().stream(), pullRequest.getParticipants().stream()).filter(participant -> user.getSlug().equals(participant.getUser().getSlug())).map(participant -> participant.getRole().name().toLowerCase()).findFirst().orElse(NO_PULL_REQUEST_ROLE);
    }
}

