/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.integration.jira.model;

import com.atlassian.applinks.api.EntityLink;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class EnhancedEntityLink {
    private final EntityLink entityLink;
    private final long projectId;

    private EnhancedEntityLink(Builder builder) {
        this.entityLink = builder.entityLink;
        this.projectId = builder.projectId;
    }

    @Nonnull
    public EntityLink getEntityLink() {
        return this.entityLink;
    }

    public long getProjectId() {
        return this.projectId;
    }

    public static class Builder
    extends BuilderSupport {
        private final EntityLink entityLink;
        private final long projectId;

        public Builder(@Nonnull EntityLink entityLink, long projectId) {
            this.entityLink = Objects.requireNonNull(entityLink, "entityLink");
            this.projectId = projectId;
        }

        @Nonnull
        public EnhancedEntityLink build() {
            return new EnhancedEntityLink(this);
        }
    }
}

