/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.integration.jira.model;

import com.atlassian.bitbucket.integration.jira.JiraIssue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class SimpleJiraIssue
implements JiraIssue,
Comparable<SimpleJiraIssue> {
    private final long issueNumber;
    private final String key;
    private final String projectKey;
    private final String url;

    public SimpleJiraIssue(String key, String url) {
        this.key = Objects.requireNonNull(key, "Issue key must not be null");
        this.url = Objects.requireNonNull(url, "Issue url must not be null");
        int offset = key.lastIndexOf("-");
        this.projectKey = key.substring(0, offset);
        this.issueNumber = Long.parseLong(key.substring(offset + 1));
    }

    @Nullable
    public static SimpleJiraIssue maybeCreate(String key, String url) {
        try {
            return new SimpleJiraIssue(key, url);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            return null;
        }
    }

    @Override
    public int compareTo(@Nonnull SimpleJiraIssue o) {
        int i = this.projectKey.compareTo(o.projectKey);
        return i == 0 ? Long.compare(this.issueNumber, o.issueNumber) : i;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleJiraIssue)) {
            return false;
        }
        return this.key.equals(((SimpleJiraIssue)obj).getKey());
    }

    @Override
    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Override
    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

