/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.integration.jira.property;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentPropertyContext;
import com.atlassian.bitbucket.comment.FlatteningCommentPropertyProvider;
import com.atlassian.bitbucket.internal.integration.jira.InternalJiraIssueService;
import com.atlassian.bitbucket.util.MoreCollectors;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;

public class JiraIssuePropertyProvider
extends FlatteningCommentPropertyProvider {
    static final String JIRA_ISSUES = "issues";
    private final InternalJiraIssueService jiraIssueService;

    public JiraIssuePropertyProvider(InternalJiraIssueService jiraIssueService) {
        this.jiraIssueService = jiraIssueService;
    }

    protected void doProvideProperties(@Nonnull CommentPropertyContext context) {
        Set commentIds = (Set)StreamSupport.stream(context.spliterator(), false).map(Comment::getId).collect(MoreCollectors.toImmutableSet());
        Map<Long, Set<String>> commentJiraIssues = this.jiraIssueService.getIssuesForComments(commentIds);
        context.forEach(comment -> {
            Set issueKeys = (Set)commentJiraIssues.get(comment.getId());
            if (issueKeys != null && !issueKeys.isEmpty()) {
                context.setProperty(comment, JIRA_ISSUES, (Object)issueKeys);
            }
        });
    }
}

