/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.integration.jira.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentableVisitor;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.integration.jira.CommentJiraIssue;
import com.atlassian.bitbucket.internal.integration.jira.InternalJiraIssueService;
import com.atlassian.bitbucket.internal.integration.jira.rest.RestCommentJiraIssue;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.rest.v2.api.resolver.CommentResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="comments")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Jira Integration")
public class CommentJiraResource {
    private final I18nService i18nService;
    private final InternalJiraIssueService issueService;

    @Inject
    public CommentJiraResource(I18nService i18nService, InternalJiraIssueService jiraIssueService) {
        this.i18nService = i18nService;
        this.issueService = jiraIssueService;
    }

    @Operation(description="Create a Jira issue and associate it with a comment on a pull request.\n\nThis resource can only be used with comments on a pull request. Attempting to call this resource with a different type of comment (for example, a comment on a commit) will result in an error. \n\n The authenticated user must have <strong>REPO_READ</strong> permission for the repository containing the comment to call this resource.\n\nThe JSON structure for the create issue format is specified by Jira's REST v2 API.", summary="Create Jira Issue")
    @Parameters(value={@Parameter(description="id of the Jira server", in=ParameterIn.QUERY, name="applicationId"), @Parameter(description="the comment to associate the created Jira issue to", in=ParameterIn.PATH, name="commentId")})
    @RequestBody(description="A String representation of the JSON format Jira create issue request see: <a href=\"https://docs.atlassian.com/jira/REST/server/#api/2/issue-createIssue\">Jira REST API</a>", content={@Content(schema=@Schema(description="application/json"))})
    @ResponseDocs(value={@ResponseDoc(documentation="The created Jira issue key and the associated comment ID", representation=RestCommentJiraIssue.class, responseCode=200), @ResponseDoc(documentation="The request body is invalid. The request body must be in the create issue format specified by Jira's REST v2 API, and contain all required fields.", restError=true, responseCode=400), @ResponseDoc(documentation="The specified application link ID does not match any linked Jira instance.", restError=true, responseCode=400), @ResponseDoc(documentation="Authentication with the Jira instance is required.", restError=true, responseCode=401)})
    @POST
    @Path(value="{commentId}/issues")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createIssue(@BeanParam CommentResolver commentResolver, final @QueryParam(value="applicationId") ApplicationId id, final String createIssueRequestJson) {
        final Comment comment = commentResolver.getComment();
        return (Response)comment.getThread().getCommentable().accept((CommentableVisitor)new CommentableVisitor<Response>(){

            public Response visit(@Nonnull CommitDiscussion discussion) {
                return ResponseFactory.badRequest((String)CommentJiraResource.this.i18nService.getMessage("bitbucket.jira.issue.create.error.commenttype", new Object[0])).build();
            }

            public Response visit(@Nonnull PullRequest pullRequest) {
                CommentJiraIssue created = CommentJiraResource.this.issueService.createIssueForComment(id, comment, createIssueRequestJson);
                return ResponseFactory.ok((Object)((Object)new RestCommentJiraIssue(created))).build();
            }
        });
    }
}

