/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.integration.jira.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.integration.jira.InternalEnhancedEntityLinkService;
import com.atlassian.bitbucket.internal.integration.jira.model.EnhancedEntityLink;
import com.atlassian.bitbucket.internal.integration.jira.rest.RestEnhancedEntityLink;
import com.atlassian.bitbucket.rest.v2.api.resolver.ProjectResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/primary-enhanced-entitylink")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Jira Integration")
public class EnhancedEntityLinkResource {
    private final InternalEnhancedEntityLinkService internalEnhancedEntityLinkService;

    @Inject
    public EnhancedEntityLinkResource(InternalEnhancedEntityLinkService internalEnhancedEntityLinkService) {
        this.internalEnhancedEntityLinkService = internalEnhancedEntityLinkService;
    }

    @Operation(description="Retrieves the enchanced primary entitylink \n\nThe authenticated user must have <strong>PROJECT_READ</strong> permission for the project having the primary enhanced entitylink. \n\n", summary="Get entity link")
    @ResponseDocs(value={@ResponseDoc(documentation="The primary enhanced entitylink.", representation=RestEnhancedEntityLink.class, responseCode=200)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getEnhancedEntityLinkForProject(@BeanParam ProjectResolver projectResolver) {
        return this.internalEnhancedEntityLinkService.findPrimaryJiraLinkByProject(projectResolver.getProject()).map(link -> ResponseFactory.ok((Object)((Object)new RestEnhancedEntityLink((EnhancedEntityLink)link))).build()).orElse(ResponseFactory.notFound().build());
    }
}

