/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.integration.jira.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.commit.Changeset;
import com.atlassian.bitbucket.integration.jira.JiraIssueService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.rest.v2.api.commit.RestChangeset;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@UnrestrictedAccess
@Consumes(value={"application/json"})
@Path(value="issues")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Jira Integration")
public class JiraResource {
    public static final String DEFAULT_MAX_CHANGES_PER_COMMIT = "10";
    private final JiraIssueService issueService;
    private final NavBuilder navBuilder;

    @Inject
    public JiraResource(JiraIssueService issueService, NavBuilder navBuilder) {
        this.issueService = issueService;
        this.navBuilder = navBuilder;
    }

    @Operation(description="Retrieve a page of changesets associated with the given issue key.", summary="Get changesets for issue key")
    @Parameters(value={@Parameter(description="The issue key to search by", in=ParameterIn.PATH, name="issueKey"), @Parameter(description="The maximum number of changes to retrieve for each changeset", in=ParameterIn.QUERY, name="maxChanges")})
    @ResponseDocs(value={@ResponseDoc(documentation="A page of detailed changesets", representation=RestChangeset.class, paged=true, responseCode=200)})
    @GET
    @Path(value="{issueKey}/commits")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getCommitsByIssueKey(@PathParam(value="issueKey") String issueKey, @BeanParam PageRequestResolver pageRequest, @QueryParam(value="maxChanges") @DefaultValue(value="10") int maxChanges) {
        Page<Changeset> changesets = this.issueService.getChangesetsForIssue(issueKey, maxChanges, pageRequest.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(changesets, changeset -> new RestChangeset(changeset, this.navBuilder, true))).build();
    }
}

