/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.integration.jira.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.integration.jira.JiraIssue;
import com.atlassian.bitbucket.integration.jira.JiraIssueService;
import com.atlassian.bitbucket.internal.integration.jira.rest.RestJiraIssue;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/issues")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key"), @PathParamDoc(name="repositorySlug", documentation="The repository slug")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Jira Integration")
public class PullRequestJiraResource {
    private final JiraIssueService issueService;

    @Inject
    public PullRequestJiraResource(JiraIssueService issueService) {
        this.issueService = issueService;
    }

    @Operation(description="Retrieves Jira issue keys that are associated with the commits in the specified pull request. The number of commits checked for issues is limited to a default of 100.", summary="Get issues for a pull request")
    @Parameter(description="The pull request id", in=ParameterIn.PATH, name="pullRequestId")
    @ApiResponses(value={@ApiResponse(description="A list of Jira issues keys for the pull request", content={@Content(array=@ArraySchema(schema=@Schema(implementation=RestJiraIssue.class)))}, responseCode="200")})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getIssueKeysForPullRequest(@BeanParam RepositoryResolver repository, @PathParam(value="pullRequestId") long pullRequestId) {
        List issues = Chainable.chain(this.getIssues(repository.getRepository(), pullRequestId)).transform(RestJiraIssue.REST_TRANSFORM).toList();
        return ResponseFactory.ok((Object)issues).build();
    }

    private Set<JiraIssue> getIssues(Repository repository, long pullRequestId) {
        return this.issueService.getIssuesForPullRequest(repository.getId(), pullRequestId);
    }
}

