/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.integration.jira.rest;

import com.atlassian.bitbucket.internal.integration.jira.model.EnhancedEntityLink;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import io.swagger.v3.oas.annotations.media.Schema;

public class RestEnhancedEntityLink
extends RestMapEntity {
    private static final String PROJECT_ID = "projectId";
    private static final String PROJECT_KEY = "projectKey";
    private static final String PROJECT_NAME = "projectName";
    private static final String APPLICATION_LINK_ID = "applicationLinkId";
    private static final String DISPLAY_URL = "displayUrl";

    public RestEnhancedEntityLink(EnhancedEntityLink metaData) {
        this(metaData.getProjectId(), metaData.getEntityLink().getKey(), metaData.getEntityLink().getName(), metaData.getEntityLink().getApplicationLink().getId().get(), metaData.getEntityLink().getDisplayUrl().toString());
    }

    private RestEnhancedEntityLink(long projectId, String projectKey, String projectName, String applicationLinkId, String displayUrl) {
        this.put(APPLICATION_LINK_ID, applicationLinkId);
        this.put(DISPLAY_URL, displayUrl);
        this.put("key", projectKey);
        this.put("name", projectName);
        this.put(PROJECT_ID, projectId);
    }

    @Schema(example="10000")
    public Long getProjectId() {
        return this.getLongProperty(PROJECT_ID);
    }

    @Schema(example="MPROJ")
    public String getProjectKey() {
        return this.getStringProperty(PROJECT_KEY);
    }

    @Schema(example="My Project")
    public String getProjectName() {
        return this.getStringProperty(PROJECT_NAME);
    }

    @Schema(example="a1b54cs4wsd45")
    public String getApplicationLinkId() {
        return this.getStringProperty(APPLICATION_LINK_ID);
    }

    @Schema(example="example.com/jira")
    public String getDisplayUrl() {
        return this.getStringProperty(DISPLAY_URL);
    }
}

