/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.integration.jira.web;

import com.atlassian.bitbucket.integration.jira.JiraIssue;
import com.atlassian.bitbucket.internal.integration.jira.InternalJiraIssueService;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefMetadataContext;
import com.atlassian.bitbucket.repository.RefMetadataProvider;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.integration.jira.JiraKeyScanner;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class BranchListMetadataProvider
implements RefMetadataProvider<List<JiraIssue>> {
    private final InternalJiraIssueService jiraIssueService;
    private final JiraKeyScanner jiraKeyScanner;

    public BranchListMetadataProvider(InternalJiraIssueService jiraIssueService, JiraKeyScanner jiraKeyScanner) {
        this.jiraIssueService = jiraIssueService;
        this.jiraKeyScanner = jiraKeyScanner;
    }

    @Nonnull
    public Map<Ref, List<JiraIssue>> getMetadata(@Nonnull RefMetadataContext context) {
        return (Map)context.getRefs().stream().collect(MoreCollectors.toImmutableMap(Function.identity(), ref -> {
            if (this.jiraIssueService.isLinked()) {
                ImmutableSet issuesKeys = ImmutableSet.copyOf((Iterable)this.jiraKeyScanner.findAll((CharSequence)ref.getId()));
                return this.jiraIssueService.findIssuesByKey((Set<String>)issuesKeys);
            }
            return Collections.emptyList();
        }));
    }
}

