/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.integration.jira.web.markup;

import com.atlassian.bitbucket.dmz.markup.renderer.MarkupRendererComponent;
import com.atlassian.bitbucket.dmz.markup.renderer.RenderContext;
import com.atlassian.bitbucket.dmz.markup.renderer.RenderTransform;
import com.atlassian.bitbucket.integration.jira.JiraIssue;
import com.atlassian.bitbucket.internal.integration.jira.InternalJiraIssueService;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.util.MarkupUtils;
import com.atlassian.integration.jira.JiraKeyScanner;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraMarkupRenderer
implements MarkupRendererComponent {
    private static final Logger log = LoggerFactory.getLogger(JiraMarkupRenderer.class);
    private static final Pattern EXCLUDE_PATTERN = MarkupUtils.LINKS;
    private static final String JIRA_MARKUP_CLASS = "markup-issues-trigger";
    private static final String LINK_TEMPLATE = "jiraIntegration.templates.trigger.issuesTrigger";
    private static final String LINK_TEMPLATE_RESOURCE = "com.atlassian.integration.jira.jira-integration-plugin:server-side-templates";
    private final InternalJiraIssueService jiraIssueService;
    private final JiraKeyScanner jiraKeyScanner;
    private final ThreadLocal<Map<String, String>> requestCache;
    private final RequestContext requestContext;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public JiraMarkupRenderer(InternalJiraIssueService jiraIssueService, JiraKeyScanner jiraKeyScanner, final RequestContext requestContext, SoyTemplateRenderer soyTemplateRenderer) {
        this.jiraIssueService = jiraIssueService;
        this.jiraKeyScanner = jiraKeyScanner;
        this.requestContext = requestContext;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.requestCache = new ThreadLocal<Map<String, String>>(){

            @Override
            protected Map<String, String> initialValue() {
                if (requestContext.isActive()) {
                    requestContext.addCleanupCallback(JiraMarkupRenderer.this.requestCache::remove);
                }
                return new HashMap<String, String>();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public RenderTransform process(CharSequence charSequence, @Nonnull RenderContext renderContext) {
        RenderTransform.TransformBuilder builder = RenderTransform.builder();
        try {
            if (this.jiraIssueService.isLinked()) {
                Map matches = this.jiraKeyScanner.findMatches(charSequence, EXCLUDE_PATTERN).asMap();
                ImmutableMap issuesByKey = Maps.uniqueIndex(this.jiraIssueService.findIssuesByKey(matches.keySet()), JiraIssue::getKey);
                matches.keySet().retainAll(issuesByKey.keySet());
                matches.forEach((arg_0, arg_1) -> this.lambda$process$1((Map)issuesByKey, builder, arg_0, arg_1));
            }
            RenderTransform renderTransform = builder.build();
            return renderTransform;
        }
        finally {
            if (!this.requestContext.isActive()) {
                this.requestCache.remove();
            }
        }
    }

    private String getOrRenderLink(JiraIssue issue) {
        String key;
        Map<String, String> cache = this.requestCache.get();
        String link = cache.get(key = issue.getKey());
        if (link == null) {
            link = this.renderLink(issue);
            cache.put(key, link);
        }
        return link;
    }

    private String renderLink(JiraIssue issue) {
        try {
            return this.soyTemplateRenderer.render(LINK_TEMPLATE_RESOURCE, LINK_TEMPLATE, (Map)ImmutableMap.of((Object)"issues", Collections.singletonList(issue), (Object)"displayedIssue", (Object)issue, (Object)"className", (Object)JIRA_MARKUP_CLASS));
        }
        catch (SoyException e) {
            log.error("Exception while rendering Jira issue links", (Throwable)e);
            return issue.getKey();
        }
    }

    private /* synthetic */ void lambda$process$1(Map issuesByKey, RenderTransform.TransformBuilder builder, String issueKey, Collection results) {
        String link = this.getOrRenderLink((JiraIssue)issuesByKey.get(issueKey));
        results.forEach(result -> builder.add(result.start(), result.end(), link));
    }
}

