/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.soy.springmvc;

import com.atlassian.soy.springmvc.errors.DetailedError;
import com.atlassian.soy.springmvc.errors.WebErrorUtils;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.validation.Errors;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public abstract class AbstractSoyResponseBuilder<B extends AbstractSoyResponseBuilder<B>> {
    protected final Object view;
    protected final Map<String, Object> model = new HashMap<String, Object>();
    private static final String DATA_ATTRIBUTES = "dataAttributes";

    public AbstractSoyResponseBuilder(String viewName) {
        this.view = viewName;
    }

    public AbstractSoyResponseBuilder(View view) {
        this.view = view;
    }

    protected abstract B self();

    public Map<String, String> getDataAttributes() {
        if (this.model.containsKey(DATA_ATTRIBUTES)) {
            return (Map)this.model.get(DATA_ATTRIBUTES);
        }
        HashMap attributes = Maps.newHashMap();
        this.model.put(DATA_ATTRIBUTES, attributes);
        return attributes;
    }

    public B put(String key, Object value) {
        this.model.put(key, value);
        return this.self();
    }

    public B putIf(boolean condition, String key, Object value) {
        if (condition) {
            this.model.put(key, value);
        }
        return this.self();
    }

    public B putValidationErrors(Errors errors) {
        this.model.put("fieldErrors", WebErrorUtils.toFieldErrorMap(errors.getFieldErrors()));
        this.model.put("formErrors", WebErrorUtils.toFormErrors(errors.getGlobalErrors()));
        return this.self();
    }

    public B putDetailedErrors(Iterable<DetailedError> detailedErrors) {
        this.model.put("detailedErrors", detailedErrors);
        return this.self();
    }

    public B putFieldErrors(Map<String, ? extends Iterable<String>> fieldErrors) {
        this.model.put("fieldErrors", fieldErrors);
        return this.self();
    }

    public B putFormErrors(String ... errors) {
        return this.putFormErrors(Arrays.asList(errors));
    }

    public B putFormErrors(Iterable<String> errors) {
        this.model.put("formErrors", errors);
        return this.self();
    }

    public B putAll(Map<String, Object> map) {
        this.model.putAll(map);
        return this.self();
    }

    public ModelAndView build() {
        return this.view instanceof String ? new ModelAndView((String)this.view, this.model) : new ModelAndView((View)this.view, this.model);
    }
}

