/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.soy.springmvc;

import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.soy.springmvc.InjectedDataFactory;
import com.google.common.base.Charsets;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import org.springframework.web.servlet.View;

public class SoyView
implements View {
    private static final String CONTENT_TYPE = "text/html;charset=UTF-8";
    private static final String STATIC = "static";
    private final InjectedDataFactory injectedDataFactory;
    private final SoyTemplateRenderer templateRenderer;
    private final String viewName;
    private final String rootModuleKey;

    public SoyView(String viewName, SoyTemplateRenderer templateRenderer, InjectedDataFactory injectedDataFactory, String rootModuleKey) {
        this.injectedDataFactory = injectedDataFactory;
        this.templateRenderer = templateRenderer;
        this.viewName = viewName;
        this.rootModuleKey = rootModuleKey;
    }

    public SoyView(String viewName, SoyTemplateRenderer templateRenderer, InjectedDataFactory injectedDataFactory) {
        this(viewName, templateRenderer, injectedDataFactory, STATIC);
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public void render(Map data, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        httpServletResponse.setContentType(this.getContentType());
        this.templateRenderer.render((Appendable)this.getWriterSafely(httpServletResponse), this.rootModuleKey, this.viewName, data == null ? Collections.emptyMap() : data, this.injectedDataFactory.createInjectedData(httpServletRequest));
    }

    private PrintWriter getWriterSafely(HttpServletResponse httpServletResponse) throws IOException {
        try {
            return httpServletResponse.getWriter();
        }
        catch (IllegalStateException e) {
            return new PrintWriter(new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), Charsets.UTF_8));
        }
    }
}

