/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.soy.springmvc;

import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.soy.springmvc.InjectedDataFactory;
import com.atlassian.soy.springmvc.SoyView;
import com.google.common.base.Preconditions;
import java.util.Locale;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.InternalResourceView;
import org.springframework.web.servlet.view.RedirectView;

public class SoyViewResolver
implements ViewResolver,
Ordered {
    public static final String REDIRECT_URL_PREFIX = "redirect:";
    public static final String FORWARD_URL_PREFIX = "forward:";
    protected final SoyTemplateRenderer templateRenderer;
    protected final InjectedDataFactory injectedDataFactory;
    private final int order;

    public SoyViewResolver(SoyTemplateRenderer templateRenderer, InjectedDataFactory injectedDataFactory) {
        this(templateRenderer, injectedDataFactory, 0);
    }

    public SoyViewResolver(SoyTemplateRenderer templateRenderer, InjectedDataFactory injectedDataFactory, int order) {
        this.templateRenderer = (SoyTemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer, (Object)"templateRenderer");
        this.injectedDataFactory = (InjectedDataFactory)Preconditions.checkNotNull((Object)injectedDataFactory, (Object)"injectedDataFactory");
        this.order = order;
    }

    public final View resolveViewName(String viewName, Locale locale) {
        if (viewName.startsWith(REDIRECT_URL_PREFIX)) {
            String redirectUrl = viewName.substring(REDIRECT_URL_PREFIX.length());
            return new RedirectView(redirectUrl, true, true);
        }
        if (viewName.startsWith(FORWARD_URL_PREFIX)) {
            String forwardUrl = viewName.substring(FORWARD_URL_PREFIX.length());
            return new InternalResourceView(forwardUrl);
        }
        return this.constructSoyView(viewName);
    }

    protected SoyView constructSoyView(String viewName) {
        return new SoyView(viewName, this.templateRenderer, this.injectedDataFactory);
    }

    public int getOrder() {
        return this.order;
    }
}

