/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.soy.springmvc.errors;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class WebErrorUtils {
    protected WebErrorUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static Map<String, ? extends Iterable<String>> toFieldErrorMap(Iterable<FieldError> fieldErrors) {
        HashMap<String, ArrayList> errors = new HashMap<String, ArrayList>();
        for (FieldError fieldError : fieldErrors) {
            if (!errors.containsKey(fieldError.getField())) {
                errors.put(fieldError.getField(), Lists.newArrayList());
            }
            ((List)errors.get(fieldError.getField())).add(fieldError.getDefaultMessage());
        }
        return errors;
    }

    public static Collection<String> toFormErrors(List<ObjectError> fieldErrors) {
        return new ArrayList<String>(Lists.transform(fieldErrors, (Function)new Function<ObjectError, String>(){

            public String apply(ObjectError error) {
                return error.getDefaultMessage();
            }
        }));
    }
}

