/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.rpc.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ByteStringUtils {
    private ByteStringUtils() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public static ByteString copyFrom(@Nonnull byte[] buffer, int offset, int length) {
        Objects.requireNonNull(buffer, "buffer");
        if (length == 0) {
            return ByteString.EMPTY;
        }
        return ByteString.copyFrom((byte[])buffer, (int)offset, (int)length);
    }

    @Nullable
    public static String emptyToNull(@Nonnull ByteString value) {
        return Objects.requireNonNull(value, "value").isEmpty() ? null : value.toStringUtf8();
    }

    @Nullable
    public static String emptyToNull(@Nullable String value) {
        return value == null || value.isEmpty() ? null : value;
    }

    @Nonnull
    public static ByteString nullToEmpty(@Nullable String value) {
        return value == null || value.isEmpty() ? ByteString.EMPTY : ByteString.copyFromUtf8((String)value);
    }

    @Nonnull
    public static Iterable<ByteString> toByteStringsLazily(@Nonnull Iterable<String> values) {
        return Iterables.transform(Objects.requireNonNull(values, "values"), ByteString::copyFromUtf8);
    }

    @Nonnull
    public static List<ByteString> toByteStringsLazily(@Nonnull List<String> values) {
        return Lists.transform(Objects.requireNonNull(values, "values"), ByteString::copyFromUtf8);
    }

    @Nonnull
    public static Map<String, ByteString> toByteStringsLazily(@Nonnull Map<String, String> values) {
        return Maps.transformValues(Objects.requireNonNull(values, "values"), ByteString::copyFromUtf8);
    }

    @Nonnull
    public static List<String> toStringsLazily(@Nonnull List<ByteString> values) {
        return Lists.transform(Objects.requireNonNull(values, "values"), ByteString::toStringUtf8);
    }

    @Nonnull
    public static Map<String, String> toStringsLazily(@Nonnull Map<String, ByteString> values) {
        return Maps.transformValues(Objects.requireNonNull(values, "values"), ByteString::toStringUtf8);
    }

    @Nonnull
    public static List<String> toStrings(@Nonnull List<ByteString> values) {
        return (List)Objects.requireNonNull(values, "values").stream().map(ByteString::toStringUtf8).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public static ByteString unsafeWrap(@Nonnull ByteBuffer buffer) {
        if (Objects.requireNonNull(buffer, "buffer").hasRemaining()) {
            ByteString bytes = UnsafeByteOperations.unsafeWrap((ByteBuffer)buffer);
            buffer.position(buffer.position() + buffer.remaining());
            return bytes;
        }
        return ByteString.EMPTY;
    }

    @Nonnull
    public static ByteString unsafeWrap(@Nonnull byte[] buffer) {
        return ByteStringUtils.unsafeWrap(buffer, 0, buffer.length);
    }

    @Nonnull
    public static ByteString unsafeWrap(@Nonnull byte[] buffer, int offset, int length) {
        Objects.requireNonNull(buffer, "buffer");
        if (length == 0) {
            return ByteString.EMPTY;
        }
        return UnsafeByteOperations.unsafeWrap((byte[])buffer, (int)offset, (int)length);
    }
}

