/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.rpc.v1;

import com.atlassian.bitbucket.mesh.rpc.v1.RpcError;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.Metadata;
import io.grpc.Status;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.slf4j.LoggerFactory;

public class RpcErrorUtils {
    private static final Metadata.Key<RpcError> KEY_ERROR = Metadata.Key.of((String)"mesh-error-bin", (Metadata.BinaryMarshaller)new Metadata.BinaryMarshaller<RpcError>(){

        public RpcError parseBytes(byte[] serialized) {
            try {
                return RpcError.parseFrom(serialized);
            }
            catch (InvalidProtocolBufferException e) {
                LoggerFactory.getLogger(RpcErrorUtils.class).warn("Failed to parse RpcError from trailer", (Throwable)e);
                return null;
            }
        }

        public byte[] toBytes(RpcError value) {
            return value.toByteArray();
        }
    });

    private RpcErrorUtils() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is a utility class and should not be instantiated");
    }

    @Nullable
    public static RpcError fromMetadata(@Nonnull Metadata metadata) {
        return (RpcError)Objects.requireNonNull(metadata, "metadata").get(KEY_ERROR);
    }

    @Nullable
    public static RpcError fromThrowable(@Nonnull Throwable t) {
        Metadata metadata = Status.trailersFromThrowable((Throwable)t);
        return metadata == null ? null : RpcErrorUtils.fromMetadata(metadata);
    }

    @Nonnull
    public static Metadata toMetadata(@Nonnull RpcError error) {
        Objects.requireNonNull(error, "error");
        Metadata metadata = new Metadata();
        metadata.put(KEY_ERROR, (Object)error);
        return metadata;
    }
}

