/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.main;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Application;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginRegistry;
import com.atlassian.plugin.SplitStartupPluginSystemLifecycle;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.event.impl.DefaultPluginEventManager;
import com.atlassian.plugin.factories.LegacyDynamicPluginFactory;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.loaders.BundledPluginLoader;
import com.atlassian.plugin.loaders.ClassPathPluginLoader;
import com.atlassian.plugin.loaders.DirectoryPluginLoader;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.main.HotDeployer;
import com.atlassian.plugin.main.PluginsConfiguration;
import com.atlassian.plugin.manager.DefaultPluginManager;
import com.atlassian.plugin.manager.PluginRegistryImpl;
import com.atlassian.plugin.manager.ProductPluginAccessor;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.container.felix.FelixOsgiContainerManager;
import com.atlassian.plugin.osgi.factory.OsgiBundleFactory;
import com.atlassian.plugin.osgi.factory.OsgiPluginFactory;
import com.atlassian.plugin.osgi.factory.RemotablePluginFactory;
import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.plugin.repositories.FilePluginInstaller;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class AtlassianPlugins {
    private OsgiContainerManager osgiContainerManager;
    private DefaultPluginEventManager pluginEventManager;
    private PluginAccessor pluginAccessor;
    private PluginController pluginController;
    private SplitStartupPluginSystemLifecycle pluginSystemLifecycle;
    private HotDeployer hotDeployer;
    private EventPublisher eventPublisher;
    public static final String TEMP_DIRECTORY_SUFFIX = ".tmp";

    public AtlassianPlugins(PluginsConfiguration config) {
        this.pluginEventManager = new DefaultPluginEventManager(config.getScopeManager());
        this.eventPublisher = this.pluginEventManager.getEventPublisher();
        AtomicReference<PluginAccessor> pluginAccessorRef = new AtomicReference<PluginAccessor>();
        this.osgiContainerManager = new FelixOsgiContainerManager(config.getFrameworkBundleDirectory(), config.getOsgiPersistentCache(), config.getPackageScannerConfiguration(), (HostComponentProvider)new CriticalHostComponentProvider(config.getHostComponentProvider(), this.pluginEventManager, pluginAccessorRef), (PluginEventManager)this.pluginEventManager);
        HashSet applications = config.getApplication() != null ? Sets.newHashSet((Object[])new Application[]{config.getApplication()}) : Collections.emptySet();
        OsgiPluginFactory osgiPluginDeployer = new OsgiPluginFactory(config.getPluginDescriptorFilename(), (Set)applications, config.getOsgiPersistentCache(), this.osgiContainerManager, (PluginEventManager)this.pluginEventManager);
        OsgiBundleFactory osgiBundleDeployer = new OsgiBundleFactory(this.osgiContainerManager);
        RemotablePluginFactory remotablePluginFactory = new RemotablePluginFactory(config.getPluginDescriptorFilename(), (Set)applications, this.osgiContainerManager, (PluginEventManager)this.pluginEventManager);
        LinkedList<PluginFactory> pluginDeployers = new LinkedList<PluginFactory>(Arrays.asList(osgiPluginDeployer, osgiBundleDeployer, remotablePluginFactory));
        if (config.isUseLegacyDynamicPluginDeployer()) {
            pluginDeployers.add(new LegacyDynamicPluginFactory(config.getPluginDescriptorFilename()));
        }
        ArrayList<PluginLoader> pluginLoaders = new ArrayList<PluginLoader>();
        pluginLoaders.add(new ClassPathPluginLoader());
        if (config.getBundledPluginUrl() != null) {
            pluginLoaders.add(new BundledPluginLoader(config.getBundledPluginUrl(), config.getBundledPluginCacheDirectory(), pluginDeployers, (PluginEventManager)this.pluginEventManager));
        }
        pluginLoaders.add(new DirectoryPluginLoader(config.getPluginDirectory(), pluginDeployers, (PluginEventManager)this.pluginEventManager));
        PluginRegistryImpl pluginRegistry = new PluginRegistryImpl();
        this.pluginAccessor = new ProductPluginAccessor((PluginRegistry.ReadOnly)pluginRegistry, config.getPluginStateStore(), config.getModuleDescriptorFactory(), this.pluginEventManager, config.getScopeManager());
        DefaultPluginManager defaultPluginManager = ((DefaultPluginManager.Builder)((DefaultPluginManager.Builder)((DefaultPluginManager.Builder)((DefaultPluginManager.Builder)((DefaultPluginManager.Builder)DefaultPluginManager.newBuilder().withPluginRegistry(pluginRegistry).withStore(config.getPluginStateStore())).withPluginLoaders(pluginLoaders)).withModuleDescriptorFactory(config.getModuleDescriptorFactory())).withPluginEventManager(this.pluginEventManager)).withPluginAccessor(this.pluginAccessor)).build();
        this.pluginController = defaultPluginManager;
        this.pluginSystemLifecycle = defaultPluginManager;
        pluginAccessorRef.set(this.pluginAccessor);
        defaultPluginManager.setPluginInstaller(new FilePluginInstaller(config.getPluginDirectory()));
        if (config.getHotDeployPollingPeriod() > 0L) {
            this.hotDeployer = new HotDeployer(this.pluginController, config.getHotDeployPollingPeriod());
        }
    }

    public void afterPropertiesSet() {
        this.pluginEventManager.register(this);
    }

    public void destroy() {
        this.pluginEventManager.unregister(this);
    }

    public OsgiContainerManager getOsgiContainerManager() {
        return this.osgiContainerManager;
    }

    public PluginEventManager getPluginEventManager() {
        return this.pluginEventManager;
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public PluginController getPluginController() {
        return this.pluginController;
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public SplitStartupPluginSystemLifecycle getPluginSystemLifecycle() {
        return this.pluginSystemLifecycle;
    }

    @PluginEventListener
    public void onPluginFrameworkStartedEvent(PluginFrameworkStartedEvent event) {
        if (this.hotDeployer != null && !this.hotDeployer.isRunning()) {
            this.hotDeployer.start();
        }
    }

    @PluginEventListener
    public void onPluginFrameworkShutdownEvent(PluginFrameworkShutdownEvent event) {
        if (this.hotDeployer != null && this.hotDeployer.isRunning()) {
            this.hotDeployer.stop();
        }
    }

    private static class CriticalHostComponentProvider
    implements HostComponentProvider {
        private final HostComponentProvider delegate;
        private final PluginEventManager pluginEventManager;
        private final AtomicReference<PluginAccessor> pluginManagerRef;

        CriticalHostComponentProvider(HostComponentProvider delegate, PluginEventManager pluginEventManager, AtomicReference<PluginAccessor> pluginManagerRef) {
            this.delegate = delegate;
            this.pluginEventManager = pluginEventManager;
            this.pluginManagerRef = pluginManagerRef;
        }

        public void provide(ComponentRegistrar registrar) {
            registrar.register(new Class[]{PluginEventManager.class}).forInstance((Object)this.pluginEventManager);
            registrar.register(new Class[]{PluginAccessor.class}).forInstance((Object)this.pluginManagerRef.get());
            this.delegate.provide(registrar);
        }
    }
}

