/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.main;

import com.atlassian.plugin.main.AtlassianPlugins;
import com.atlassian.plugin.main.PackageScannerConfigurationBuilder;
import com.atlassian.plugin.main.PluginsConfiguration;
import com.atlassian.plugin.main.PluginsConfigurationBuilder;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Main.initialiseLogger();
        File pluginDir = new File("plugins");
        if (pluginDir.mkdir()) {
            System.out.println("Created plugins directory " + pluginDir.getAbsolutePath());
        } else if (pluginDir.isDirectory()) {
            System.out.println("Using existing plugins directory " + pluginDir.getAbsolutePath());
        } else {
            System.out.println("Cannot create plugins directory " + pluginDir.getAbsolutePath());
        }
        PackageScannerConfiguration packageScannerConfiguration = PackageScannerConfigurationBuilder.packageScannerConfiguration().packagesToInclude("org.apache.*", "com.atlassian.*", "org.dom4j*").packagesVersions(Collections.singletonMap("org.apache.log4j", "1.2.17-atlassian-13")).build();
        PluginsConfiguration config = PluginsConfigurationBuilder.pluginsConfiguration().pluginDirectory(pluginDir).packageScannerConfiguration(packageScannerConfiguration).hotDeployPollingFrequency(5L, TimeUnit.SECONDS).build();
        AtlassianPlugins plugins = new AtlassianPlugins(config);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.out.println("Cleaning up...");
            plugins.getPluginSystemLifecycle().shutdown();
            plugins.destroy();
        }));
        plugins.afterPropertiesSet();
        plugins.getPluginSystemLifecycle().init();
        try {
            Object waitable;
            Object object = waitable = new Object();
            synchronized (object) {
                waitable.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void initialiseLogger() {
        Properties logProperties = new Properties();
        try (InputStream in = Main.class.getResourceAsStream("/log4j-standalone.properties");){
            logProperties.load(in);
            PropertyConfigurator.configure((Properties)logProperties);
            Logger.getLogger(Main.class).info((Object)"Logging initialized.");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load logging");
        }
    }
}

