/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.util.Objects;
import org.apache.velocity.runtime.log.Log;

public class Info {
    private int line;
    private int column;
    private String templateName;

    public Info(String source, int line, int column) {
        this.templateName = source;
        this.line = line;
        this.column = column;
    }

    private Info() {
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        return Log.formatFileString(this.getTemplateName(), this.getLine(), this.getColumn());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Info info = (Info)o;
        return this.line == info.line && this.column == info.column && Objects.equals(this.templateName, info.templateName);
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column, this.templateName);
    }
}

