/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.velocity.util.introspection.MethodTranslator;

public class MethodTranslatorImpl
implements MethodTranslator {
    private static final Map<Method, Method> interfaceMethodCache = Collections.synchronizedMap(new WeakHashMap());

    @Override
    public Method getTranslatedMethod(Object target, Method method) {
        if (!target.getClass().getSimpleName().contains("$")) {
            return method;
        }
        return MethodTranslatorImpl.getInterfaceMethodIfPossible(method, target.getClass());
    }

    public static Method getInterfaceMethodIfPossible(Method method, Class<?> targetClass) {
        if (!Modifier.isPublic(method.getModifiers()) || method.getDeclaringClass().isInterface()) {
            return method;
        }
        Method result = interfaceMethodCache.computeIfAbsent(method, key -> MethodTranslatorImpl.findInterfaceMethodIfPossible(key, key.getDeclaringClass(), Object.class));
        if (result == method && targetClass != null) {
            result = MethodTranslatorImpl.findInterfaceMethodIfPossible(method, targetClass, method.getDeclaringClass());
        }
        return result;
    }

    private static Method findInterfaceMethodIfPossible(Method method, Class<?> startClass, Class<?> endClass) {
        for (Class<?> current = startClass; current != null && current != endClass; current = current.getSuperclass()) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = current.getInterfaces()) {
                try {
                    return ifc.getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        return method;
    }
}

