/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git;

import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.util.ShaUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class GitUtils {
    public static final String NULL_SHA1 = ShaUtils.NULL_SHA1;
    public static final String NULL_TREE = "4b825dc642cb6eb9a060e54bf8d69288fbee4904";
    public static final int TYPE_NULL = 0;
    public static final int TYPE_DIRECTORY = 40;
    public static final int TYPE_FILE = 100;
    public static final int TYPE_SYMBOLIC_LINK = 120;
    public static final int TYPE_SUBMODULE_LINK = 160;
    private static final List<Charset> CHARSETS = ImmutableList.of((Object)StandardCharsets.UTF_8, (Object)StandardCharsets.ISO_8859_1);
    private static final int LINE_WRAP_LENGTH = 79;
    private static final char REPLACEMENT_CHAR = '\ufffd';
    private static final Pattern UNESCAPE_PATTERN = Pattern.compile("\".*\"");

    private GitUtils() {
        throw new UnsupportedOperationException("Static utility class - not for instantiation");
    }

    public static boolean isDirectory(@Nonnull String value) {
        return GitUtils.getType(value) == 40;
    }

    public static Boolean isExecutable(@Nonnull String value) {
        int type = GitUtils.getType(value);
        if (type == 0) {
            return null;
        }
        if (type == 120) {
            return true;
        }
        int mode = Integer.parseInt(value.substring(3));
        return mode / 100 % 2 == 1;
    }

    public static boolean isFile(@Nonnull String value) {
        return GitUtils.getType(value) == 100;
    }

    public static boolean isSubmodule(@Nonnull String value) {
        return GitUtils.getType(value) == 160;
    }

    public static boolean isSymbolicLink(@Nonnull String value) {
        return GitUtils.getType(value) == 120;
    }

    public static boolean isHash(String value) {
        return ShaUtils.isHash((String)value);
    }

    public static boolean refsMatch(@Nonnull Ref left, @Nullable Ref right) {
        return right != null && Objects.requireNonNull(left, "left").getLatestCommit().equals(right.getLatestCommit());
    }

    public static String unescape(String s) {
        if (s == null) {
            return null;
        }
        int start = 0;
        int end = s.length();
        if (s.matches("\".*\"")) {
            ++start;
            --end;
        }
        byte[] bytes = new byte[end - start];
        int index = 0;
        for (int i = start; i < end; ++i) {
            int c = s.charAt(i);
            if (c == 92 && ++i < end) {
                c = s.charAt(i);
                switch (c) {
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 34: {
                        c = 34;
                        break;
                    }
                    case 92: {
                        c = 92;
                        break;
                    }
                    default: {
                        if (!Character.isDigit(c)) break;
                        c -= 48;
                        if (++i >= end) break;
                        c = c * 8 + s.charAt(i) - 48;
                        if (++i >= end) break;
                        c = c * 8 + s.charAt(i) - 48;
                    }
                }
            }
            bytes[index++] = (byte)c;
        }
        for (Charset charset : CHARSETS) {
            String normalized = Normalizer.normalize(new String(bytes, 0, index, charset), Normalizer.Form.NFC);
            if (normalized.indexOf(65533) != -1) continue;
            return normalized;
        }
        return new String(bytes);
    }

    public static String unescapeQuoted(String s) {
        if (s != null && UNESCAPE_PATTERN.matcher(s).matches()) {
            return GitUtils.unescape(s);
        }
        return s;
    }

    public static String wordWrap(String line) {
        if (line.length() < 79 || !line.contains(" ")) {
            return line;
        }
        String[] words = StringUtils.splitPreserveAllTokens((String)line);
        StringBuilder builder = new StringBuilder(line.length() + 100);
        int currentLength = 0;
        for (String word : words) {
            if (word.isEmpty()) {
                builder.append("\n\n");
                currentLength = 0;
                continue;
            }
            if (currentLength + word.length() + 1 > 79) {
                builder.append("\n");
                currentLength = 0;
            } else if (currentLength > 0) {
                builder.append(" ");
                ++currentLength;
            }
            builder.append(word);
            currentLength += word.length();
        }
        return builder.toString();
    }

    private static int getType(String value) {
        Objects.requireNonNull(value, "value");
        Preconditions.checkArgument((value.length() == 6 ? 1 : 0) != 0, (Object)"A git-style mode, 6 digits long, is required");
        return Integer.parseInt(value.substring(0, 3));
    }
}

