/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.command;

import com.atlassian.bitbucket.io.BaseCommandHandler;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommandAware;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.google.common.io.ByteStreams;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoggingCommandOutputHandler<T>
extends BaseCommandHandler
implements CommandAware,
CommandOutputHandler<T> {
    private Command<?> command;
    private Logger log;

    public AbstractLoggingCommandOutputHandler() {
    }

    public AbstractLoggingCommandOutputHandler(@Nonnull Logger log) {
        this.log = Objects.requireNonNull(log, "log");
    }

    public void process(@Nonnull InputStream stream) throws IOException {
        byte[] bytes = ByteStreams.toByteArray((InputStream)stream);
        if (bytes.length == 0) {
            this.log.trace("{}: Completed with no output", this.command);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("{}: Completed with the following output:\n{}", this.command, (Object)new String(bytes, StandardCharsets.UTF_8));
        }
    }

    public void setCommand(@Nonnull Command<?> command) {
        this.command = Objects.requireNonNull(command, "command");
        if (this.log == null) {
            this.log = LoggerFactory.getLogger((Class)command.getClass());
        }
    }
}

