/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.command;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.CommitMessageMode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class CommitReaderSettings {
    public static final int UNLIMITED_MESSAGE_LENGTH = -1;
    private final int maxMessageLength;
    private final CommitMessageMode messageMode;
    private final Repository repository;

    private CommitReaderSettings(Builder builder) {
        this.maxMessageLength = builder.messageMode == CommitMessageMode.NONE ? 0 : Math.max(-1, builder.maxMessageLength);
        this.messageMode = builder.maxMessageLength == 0 ? CommitMessageMode.NONE : builder.messageMode;
        this.repository = builder.repository;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    @Nonnull
    public CommitMessageMode getMessageMode() {
        return this.messageMode;
    }

    @Nullable
    public Repository getRepository() {
        return this.repository;
    }

    public boolean isMessageLengthUnlimited() {
        return this.maxMessageLength == -1;
    }

    public boolean isWithMessages() {
        return this.messageMode != CommitMessageMode.NONE;
    }

    public static class Builder {
        private int maxMessageLength = -1;
        private CommitMessageMode messageMode = CommitMessageMode.RAW_BODY;
        private Repository repository;

        @Nonnull
        public CommitReaderSettings build() {
            return new CommitReaderSettings(this);
        }

        @Nonnull
        public Builder maxMessageLength(int value) {
            this.maxMessageLength = value;
            return this;
        }

        @Nonnull
        public Builder messageMode(@Nonnull CommitMessageMode value) {
            this.messageMode = Objects.requireNonNull(value, "messageMode");
            return this;
        }

        @Nonnull
        public Builder repository(@Nullable Repository value) {
            this.repository = value;
            return this;
        }

        @Nonnull
        public Builder withMessages(boolean value) {
            if (value) {
                if (this.messageMode == CommitMessageMode.NONE) {
                    this.messageMode = CommitMessageMode.RAW_BODY;
                }
            } else {
                this.messageMode = CommitMessageMode.NONE;
            }
            return this;
        }
    }
}

