/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.command;

import com.atlassian.bitbucket.NoSuchObjectException;
import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.content.NoSuchPathException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryArchivedException;
import com.atlassian.bitbucket.repository.RepositoryReadOnlyException;
import com.atlassian.bitbucket.scm.CommandFailedException;
import com.atlassian.bitbucket.scm.CommandUsageException;
import com.atlassian.bitbucket.scm.DefaultCommandExitHandler;
import com.atlassian.bitbucket.scm.ProcessFailedException;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitCommandExitHandler
extends DefaultCommandExitHandler {
    public static final Pattern ADVICE_PATTERN = Pattern.compile("(?:^|\n)hint:[ ]?.*?(?:\n|$)", 8);
    public static final String ERROR_REPOSITORY_READ_ONLY = "bitbucket: read-only";
    public static final Pattern PATTERN_BAD_OBJECT = Pattern.compile("fatal: bad object ([0-9a-f]+)");
    public static final Pattern PATTERN_BAD_REVISION = Pattern.compile("(?s).*fatal: bad revision '\\^?(.+)'");
    public static final Pattern PATTERN_NOT_FOUND = Pattern.compile("fatal: Not a valid object name (?:([^:]*):?(.*))");
    public static final Pattern PATTERN_NOT_FOUND_OBJECT = Pattern.compile("fatal: invalid object name '(.*)'\\.");
    public static final Pattern PATTERN_NOT_FOUND_PATH = Pattern.compile("fatal: path '(.*)' does not exist in '(.*)'");
    public static final String USAGE = "usage:";
    private static final String ERR_MIGRATED_TO_MESH = "bitbucket: migrated to Mesh";
    private static final String NOT_REPOSITORY = "fatal: not a git repository";
    private static final Logger log = LoggerFactory.getLogger(GitCommandExitHandler.class);
    protected final Repository repository;

    public GitCommandExitHandler(@Nonnull I18nService i18nService, @Nullable Repository repository) {
        super(i18nService);
        this.repository = repository;
    }

    public void onCancel(@Nonnull String command, int exitCode, @Nullable String stdErr, @Nullable Throwable thrown) {
        if (StringUtils.isNotBlank((CharSequence)stdErr)) {
            this.evaluateStdErr(stdErr, command);
        }
        if (thrown != null) {
            this.evaluateThrowable(thrown, command, exitCode, stdErr);
        }
        super.onCancel(command, exitCode, stdErr, thrown);
    }

    protected void checkUsage(String stdErr, String command) {
        if (stdErr.startsWith(USAGE)) {
            log.error("[{}] The syntax used is incorrect. git exited and printed a usage block", (Object)command);
            throw new CommandUsageException(this.i18nService.createKeyedMessage("bitbucket.scm.git.invalid.syntax", new Object[0]), command, stdErr);
        }
    }

    protected void evaluateStdErr(String stdErr, String command) {
        this.checkUsage(stdErr, command);
        if (stdErr.startsWith(NOT_REPOSITORY)) {
            throw new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.scm.git.notrepository", new Object[0]));
        }
        Matcher matcher = PATTERN_BAD_OBJECT.matcher(stdErr);
        if (matcher.matches()) {
            throw this.newNoSuchCommitException(matcher.group(1));
        }
        matcher = PATTERN_BAD_REVISION.matcher(stdErr);
        if (matcher.matches()) {
            throw this.newNoSuchCommitException(matcher.group(1));
        }
        matcher = PATTERN_NOT_FOUND.matcher(stdErr);
        if (matcher.matches()) {
            if (StringUtils.isEmpty((CharSequence)matcher.group(2))) {
                throw this.newNoObjectException(matcher.group(1));
            }
            throw this.newNoSuchPathException(matcher.group(1), matcher.group(2));
        }
        matcher = PATTERN_NOT_FOUND_OBJECT.matcher(stdErr);
        if (matcher.matches()) {
            throw this.newNoObjectException(matcher.group(1));
        }
        matcher = PATTERN_NOT_FOUND_PATH.matcher(stdErr);
        if (matcher.matches()) {
            throw this.newNoSuchPathException(matcher.group(2), matcher.group(1));
        }
        if (stdErr.contains(ERROR_REPOSITORY_READ_ONLY) || stdErr.contains(ERR_MIGRATED_TO_MESH)) {
            throw this.repository != null && this.repository.isArchived() ? this.newRepositoryArchivedException() : this.newRepositoryReadOnlyException();
        }
    }

    protected void evaluateThrowable(Throwable thrown, String command, int exitCode, String stdErr) {
        if (this.isNonZeroExitCodeException(thrown = Throwables.getRootCause((Throwable)thrown))) {
            super.onError(command, exitCode, stdErr, thrown);
        }
        if (thrown instanceof ServiceException) {
            throw (ServiceException)thrown;
        }
        if (!(thrown instanceof IOException) || !"Broken pipe".equals(thrown.getMessage())) {
            throw new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.externalprocess.exception", new Object[]{thrown.getMessage()}), thrown);
        }
        log.debug("{}: Broken pipe while streaming output for {}", (Object)this.repository, (Object)command);
    }

    protected boolean isError(String command, int exitCode, String stdErr, Throwable thrown) {
        return exitCode != 0 || thrown != null || this.isErrorOutput(command, stdErr);
    }

    protected boolean isErrorOutput(String command, String stdErr) {
        if (StringUtils.isNotBlank((CharSequence)stdErr)) {
            String[] lines;
            for (String line : lines = stdErr.toLowerCase().split("\\n")) {
                if (!this.isErrorOutput(line)) continue;
                return true;
            }
            log.debug("{} did not fail, but the following was written to stderr:\n{}", (Object)command, (Object)stdErr);
        }
        return false;
    }

    protected boolean isErrorOutput(String line) {
        return line.startsWith("error") || line.startsWith("fatal") || line.startsWith(USAGE);
    }

    protected boolean isNonZeroExitCodeException(Throwable thrown) {
        return thrown instanceof ProcessFailedException && ((ProcessFailedException)thrown).getExitCode() != 0;
    }

    protected NoSuchObjectException newNoObjectException(String objectName) {
        KeyedMessage message = this.repository == null ? this.i18nService.createKeyedMessage("bitbucket.service.repository.objectnotfound.generic", new Object[]{objectName}) : this.i18nService.createKeyedMessage("bitbucket.service.repository.objectnotfound", new Object[]{this.repository.getName(), objectName});
        throw new NoSuchObjectException(message, objectName);
    }

    protected NoSuchCommitException newNoSuchCommitException(String commitId) {
        if (this.repository != null) {
            throw new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.service.repository.commitnotfound", new Object[]{this.repository.getName(), commitId}), commitId);
        }
        throw new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.service.repository.commitnotfound.generic", new Object[]{commitId}), commitId);
    }

    protected NoSuchPathException newNoSuchPathException(String commitId, String path) {
        throw new NoSuchPathException(this.i18nService.createKeyedMessage("bitbucket.service.repository.pathnotfound.atrevision", new Object[]{path, commitId}), path, commitId);
    }

    protected RepositoryArchivedException newRepositoryArchivedException() {
        throw new RepositoryArchivedException(this.i18nService.createKeyedMessage("bitbucket.service.repository.updatearchived", new Object[0]));
    }

    protected RepositoryReadOnlyException newRepositoryReadOnlyException() {
        throw new RepositoryReadOnlyException(this.i18nService.createKeyedMessage("bitbucket.scm.git.repository.readonly", new Object[0]));
    }

    protected void onError(String command, int exitCode, String stdErr, Throwable thrown) {
        if (StringUtils.isNotBlank((CharSequence)stdErr)) {
            this.evaluateStdErr(stdErr, command);
        }
        if (thrown != null) {
            this.evaluateThrowable(thrown, command, exitCode, stdErr);
        }
        super.onError(command, exitCode, stdErr, thrown);
    }
}

