/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.attachment;

import com.atlassian.bitbucket.attachment.Attachment;
import com.atlassian.bitbucket.attachment.AttachmentMetadata;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.attachment.AttachmentDao;
import com.atlassian.stash.internal.attachment.InternalAttachment;
import com.atlassian.stash.internal.querybuilder.HqlQueryBuilder;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HibernateAttachmentDao
extends AbstractHibernateDao<Long, InternalAttachment>
implements AttachmentDao {
    private static final List<HqlQueryBuilder.HqlQueryOrder> IMPLICIT_QUERY_ORDER = Collections.singletonList(HqlQueryBuilder.HqlQueryOrder.desc((String)"id"));

    @Autowired
    public HibernateAttachmentDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public void exportAll(int repositoryId, @Nonnull BiConsumer<Attachment, AttachmentMetadata> exporter, int pageSize) {
        String hql = "select a, m from InternalAttachment a left outer join InternalAttachmentMetadata m on m.attachmentId = a.id where a.repository.id = :repositoryId order by a.id";
        Query query = this.session().createQuery(hql, Object[].class).setParameter("repositoryId", (Object)repositoryId);
        PageUtils.toStream(request -> this.pageQuery(query, request), (int)pageSize).forEach(row -> exporter.accept((Attachment)row[0], (AttachmentMetadata)row[1]));
    }

    public InternalAttachment update(InternalAttachment entity) {
        throw new UnsupportedOperationException("Cannot update immutable objects like attachments");
    }

    public InternalAttachment getById(Long id) {
        return (InternalAttachment)HibernateUtils.initialize((Object)((InternalAttachment)super.getById((Serializable)id)));
    }

    protected Iterable<HqlQueryBuilder.HqlQueryOrder> getImplicitOrder() {
        return IMPLICIT_QUERY_ORDER;
    }
}

