/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.auth.InternalRememberMeToken;
import com.atlassian.stash.internal.auth.RememberMeTokenDao;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Repository;

@Repository(value="rememberMeTokenDao")
public class HibernateRememberMeTokenDao
extends AbstractHibernateDao<Long, InternalRememberMeToken>
implements RememberMeTokenDao {
    @Autowired
    public HibernateRememberMeTokenDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public boolean claim(@Nonnull InternalRememberMeToken token) {
        int updated = this.session().createQuery("update InternalRememberMeToken set expiryDate = :newExpiry, claimed = true, remoteAddress = :hostname where series = :series and token = :token and claimed = false and expiryDate > :now").setParameter("newExpiry", (Object)token.getExpiryDate()).setParameter("hostname", (Object)token.getRemoteAddress()).setParameter("series", (Object)token.getSeries()).setParameter("token", (Object)token.getToken()).setParameter("now", (Object)new Date()).executeUpdate();
        if (updated > 1) {
            throw new DataIntegrityViolationException("more than one remember-me token was claimed");
        }
        return updated == 1;
    }

    public int deleteExpiredTokens(long maxExpiredTime, @Nonnull TimeUnit timeUnit) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.add(13, (int)(-timeUnit.toSeconds(maxExpiredTime)));
        Date maxExpiredDate = calendar.getTime();
        return this.session().createQuery("delete from InternalRememberMeToken where expiryDate < :expiryDate").setParameter("expiryDate", (Object)maxExpiredDate).executeUpdate();
    }

    public int deleteForSeries(@Nonnull String series) {
        return this.session().createQuery("delete from InternalRememberMeToken where series = :series").setParameter("series", (Object)series).executeUpdate();
    }

    public int deleteForUser(int userId) {
        return this.session().createQuery("delete from InternalRememberMeToken where user.id = :userId").setParameter("userId", (Object)userId).executeUpdate();
    }

    @Nonnull
    public Page<InternalRememberMeToken> findAll(PageRequest pageRequest) {
        return HibernateUtils.initializePage((Page)super.findAll(pageRequest));
    }

    @Nonnull
    public Page<InternalRememberMeToken> findAll(PageRequest pageRequest, Predicate<? super InternalRememberMeToken> predicate) {
        return HibernateUtils.initializePage((Page)super.findAll(pageRequest, predicate));
    }

    @Nullable
    public InternalRememberMeToken findBySeriesAndToken(@Nonnull String series, @Nonnull String token) {
        return (InternalRememberMeToken)HibernateUtils.initialize((Object)((InternalRememberMeToken)this.session().createQuery("from InternalRememberMeToken where series = :series and token = :token").setParameter("series", (Object)series).setParameter("token", (Object)token).uniqueResult()));
    }

    public InternalRememberMeToken getById(Long id) {
        return (InternalRememberMeToken)HibernateUtils.initialize((Object)((InternalRememberMeToken)super.getById((Serializable)id)));
    }

    @Nonnull
    public List<InternalRememberMeToken> getByIds(@Nonnull Collection<Long> ids) {
        return HibernateUtils.initializeList((List)super.getByIds(ids));
    }

    public InternalRememberMeToken loadById(Long id) {
        return (InternalRememberMeToken)HibernateUtils.initialize((Object)((InternalRememberMeToken)super.loadById((Serializable)id)));
    }

    public void refresh(InternalRememberMeToken entity) {
        super.refresh((Object)entity);
        HibernateUtils.initialize((Object)entity);
    }

    public InternalRememberMeToken update(InternalRememberMeToken entity) {
        return (InternalRememberMeToken)HibernateUtils.initialize((Object)((InternalRememberMeToken)super.update((Object)entity)));
    }
}

