/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.autodecline;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.stash.internal.AbstractHibernateDao;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.autodecline.AutoDeclineSettingsDao;
import com.atlassian.stash.internal.autodecline.InternalAutoDeclineSettings;
import com.atlassian.stash.internal.scope.Scopeable;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="autoDeclineSettingsDao")
public class HibernateAutoDeclineSettingsDao
extends AbstractHibernateDao<Long, InternalAutoDeclineSettings>
implements AutoDeclineSettingsDao {
    @Autowired
    public HibernateAutoDeclineSettingsDao(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public int deleteByScope(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        String hql = "DELETE FROM InternalAutoDeclineSettings WHERE scope = :scope";
        return this.session().createQuery(hql).setParameter("scope", (Object)Scopeable.fromScope((Scope)scope)).executeUpdate();
    }

    public Optional<InternalAutoDeclineSettings> findByScope(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        String hql = "FROM InternalAutoDeclineSettings WHERE scope = :scope";
        return this.session().createQuery(hql, InternalAutoDeclineSettings.class).setParameter("scope", (Object)Scopeable.fromScope((Scope)scope)).uniqueResultOptional().map(HibernateUtils::initialize);
    }

    @Nonnull
    public Optional<InternalAutoDeclineSettings> findInheritedByScopes(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        Collection<Scopeable> scopeables = HibernateAutoDeclineSettingsDao.getInheritedScopeables(scope);
        if (scopeables.isEmpty()) {
            return Optional.empty();
        }
        String hql = "FROM InternalAutoDeclineSettings WHERE scope IN :scopes order by scope_type desc";
        return this.session().createQuery(hql, InternalAutoDeclineSettings.class).setParameterList("scopes", scopeables).setMaxResults(1).uniqueResultOptional().map(HibernateUtils::initialize);
    }

    private static Collection<Scopeable> getInheritedScopeables(Scope scope) {
        return (Collection)scope.accept((ScopeVisitor)new ScopeVisitor<Set<Scopeable>>(){

            public Set<Scopeable> visit(@Nonnull GlobalScope scope) {
                return Collections.emptySet();
            }

            public Set<Scopeable> visit(@Nonnull ProjectScope scope) {
                return ImmutableSet.of((Object)Scopeable.fromScope((Scope)scope));
            }

            public Set<Scopeable> visit(@Nonnull RepositoryScope scope) {
                return ImmutableSet.of((Object)Scopeable.fromScope((Scope)scope), (Object)Scopeable.fromScope((Scope)Scopes.project((Project)scope.getProject())));
            }
        });
    }
}

